/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.Player;

import java.util.Collections;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.lunark.io.ServerEssentials;
import net.lunark.io.util.PlayerMessages;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SetLoreLineCommand
implements CommandExecutor {
    private final PlayerMessages messages;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();

    public SetLoreLineCommand(ServerEssentials plugin) {
        this.messages = plugin.getPlayerMessages();
        this.messages.addDefault("setlore.usage", "<red>Usage: /setloreline <text>");
        this.messages.addDefault("setlore.no-player", "<red>Only players can use this command.");
        this.messages.addDefault("setlore.no-item", "<red>You're not holding an item.");
        this.messages.addDefault("setlore.lore-set", "<green>Lore set to: <white>{lore}");
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            this.playerSend(sender, "setlore.no-player", new String[0]);
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.playerSend(player, "setlore.usage", new String[0]);
            return true;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null || item.getType().isAir()) {
            this.playerSend(player, "setlore.no-item", new String[0]);
            return true;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return true;
        }
        String input = String.join((CharSequence)" ", args);
        Object loreComponent = this.miniMessage.deserialize(input);
        meta.lore(Collections.singletonList(loreComponent));
        item.setItemMeta(meta);
        this.playerSend(player, "setlore.lore-set", "{lore}", input);
        return true;
    }

    private void playerSend(Player player, String path, String ... placeholders) {
        Component message = this.messages.get(path, placeholders);
        player.sendMessage(message);
    }

    private void playerSend(CommandSender sender, String path, String ... placeholders) {
        Component message = this.messages.get(path, placeholders);
        sender.sendMessage(message);
    }
}

