/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.Player;

import net.kyori.adventure.text.Component;
import net.lunark.io.ServerEssentials;
import net.lunark.io.util.PlayerMessages;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SpeedCommand
implements CommandExecutor {
    private final PlayerMessages messages;

    public SpeedCommand(ServerEssentials plugin) {
        this.messages = plugin.getPlayerMessages();
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            Component msg = this.messages.get("Speed.only-players", new String[0]);
            sender.sendMessage(msg);
            return true;
        }
        Player player = (Player)sender;
        if (args.length != 1) {
            Component usageMsg = this.messages.get("Speed.usage", new String[0]);
            player.sendMessage(usageMsg);
            return true;
        }
        try {
            int speed = Integer.parseInt(args[0]);
            if (speed < 1 || speed > 10) {
                throw new NumberFormatException();
            }
            float scaled = (float)speed / 10.0f;
            if (player.isFlying()) {
                player.setFlySpeed(scaled);
                Component flyMsg = this.messages.get("Speed.fly-set", "{speed}", String.valueOf(speed));
                player.sendMessage(flyMsg);
            } else {
                player.setWalkSpeed(scaled);
                Component walkMsg = this.messages.get("Speed.walk-set", "{speed}", String.valueOf(speed));
                player.sendMessage(walkMsg);
            }
        }
        catch (NumberFormatException e) {
            Component invalidMsg = this.messages.get("Speed.invalid-number", new String[0]);
            player.sendMessage(invalidMsg);
        }
        return true;
    }
}

