/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.Player;

import net.kyori.adventure.text.Component;
import net.lunark.io.ServerEssentials;
import net.lunark.io.util.PlayerMessages;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TrackCommand
implements CommandExecutor {
    private final PlayerMessages messages;

    public TrackCommand(ServerEssentials plugin) {
        this.messages = plugin.getPlayerMessages();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            Component msg = this.messages.get("Track.only-players", new String[0]);
            sender.sendMessage(msg);
            return true;
        }
        Player player = (Player)sender;
        if (args.length != 1) {
            Component usageMsg = this.messages.get("Track.usage", new String[0]);
            player.sendMessage(usageMsg);
            return true;
        }
        Player target = Bukkit.getPlayerExact((String)args[0]);
        if (target == null || !target.isOnline()) {
            Component notFoundMsg = this.messages.get("Track.not-found", "{target}", args[0]);
            player.sendMessage(notFoundMsg);
            return true;
        }
        Location targetLoc = target.getLocation();
        player.setCompassTarget(targetLoc);
        Component successMsg = this.messages.get("Track.success", "{target}", target.getName());
        player.sendMessage(successMsg);
        return true;
    }
}

