/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.Player;

import net.kyori.adventure.text.Component;
import net.lunark.io.ServerEssentials;
import net.lunark.io.util.PlayerMessages;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class WorldCommand
implements CommandExecutor {
    private final ServerEssentials plugin;
    private final PlayerMessages messages;

    public WorldCommand(ServerEssentials plugin) {
        this.plugin = plugin;
        this.messages = plugin.getPlayerMessages();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            Component msg = this.messages.get("World.only-players", new String[0]);
            sender.sendMessage(msg);
            return true;
        }
        Player player = (Player)sender;
        if (args.length > 0) {
            Component usageMsg = this.messages.get("World.usage", "{player}", player.getName());
            player.sendMessage(usageMsg);
            return true;
        }
        Component worldMsg = this.messages.get("World.current-world", "{player}", player.getName(), "{world}", player.getWorld().getName());
        player.sendMessage(worldMsg);
        return true;
    }
}

