/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.Rtp;

import java.util.List;
import net.kyori.adventure.text.Component;
import net.lunark.io.ServerEssentials;
import net.lunark.io.config.RTPConfig;
import net.lunark.io.util.RTPMessages;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class RTPCommand
implements CommandExecutor {
    private final ServerEssentials plugin;

    public RTPCommand(ServerEssentials plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 1 && args[0].equalsIgnoreCase("reload")) {
            if (!sender.hasPermission("rtp.reload")) {
                RTPMessages msg = new RTPMessages(this.plugin);
                sender.sendMessage(msg.get("no-permission", new String[0]));
                return true;
            }
            RTPConfig.fullReload();
            RTPMessages.fullReload();
            RTPMessages msg = RTPMessages.getInstance();
            sender.sendMessage(msg.get("reload-success", new String[0]));
            return true;
        }
        if (!(sender instanceof Player)) {
            RTPMessages msg = new RTPMessages(this.plugin);
            sender.sendMessage(msg.get("only-player", new String[0]));
            return true;
        }
        Player player = (Player)sender;
        RTPMessages messages = new RTPMessages(this.plugin);
        Component title = messages.get("gui.title", new String[0]);
        Inventory gui = Bukkit.createInventory(null, (int)9, (Component)title);
        ItemStack overworld = this.createGuiItem(Material.GRASS_BLOCK, messages.get("gui.overworld.name", new String[0]), messages.getList("gui.overworld.lore", new String[0]));
        ItemStack nether = this.createGuiItem(Material.NETHERRACK, messages.get("gui.nether.name", new String[0]), messages.getList("gui.nether.lore", new String[0]));
        ItemStack theEnd = this.createGuiItem(Material.END_STONE, messages.get("gui.end.name", new String[0]), messages.getList("gui.end.lore", new String[0]));
        gui.setItem(2, overworld);
        gui.setItem(4, nether);
        gui.setItem(6, theEnd);
        player.openInventory(gui);
        return true;
    }

    private ItemStack createGuiItem(Material material, Component name, List<Component> lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(name);
        meta.lore(lore);
        item.setItemMeta(meta);
        return item;
    }
}

