/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.Rtp;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.lunark.io.Managers.BackManager;
import net.lunark.io.Managers.CooldownManager;
import net.lunark.io.ServerEssentials;
import net.lunark.io.config.RTPConfig;
import net.lunark.io.util.RTPMessages;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class RTPListener
implements Listener {
    private final ServerEssentials plugin;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();

    public RTPListener(ServerEssentials plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        World world;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        RTPMessages messages = new RTPMessages(this.plugin);
        String expected = (String)MiniMessage.miniMessage().serialize(messages.get("gui.title", new String[0]));
        String actual = (String)MiniMessage.miniMessage().serialize(event.getView().title());
        if (!expected.equals(actual)) {
            return;
        }
        event.setCancelled(true);
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        switch (clicked.getType()) {
            case GRASS_BLOCK: {
                World world2 = Bukkit.getWorld((String)"world");
                break;
            }
            case NETHERRACK: {
                World world2 = Bukkit.getWorld((String)"world_nether");
                break;
            }
            case END_STONE: {
                World world2 = Bukkit.getWorld((String)"world_the_end");
                break;
            }
            default: {
                World world2 = world = null;
            }
        }
        if (world == null) {
            player.sendMessage(messages.get("world-not-loaded", new String[0]));
            return;
        }
        if (!RTPConfig.isEnabled(world.getName())) {
            player.sendMessage(messages.get("world-disabled", new String[0]));
            return;
        }
        if (CooldownManager.isOnCooldown(player.getUniqueId())) {
            long remaining = CooldownManager.getRemaining(player.getUniqueId());
            player.sendMessage(messages.get("cooldown", "{seconds}", String.valueOf(remaining)));
            return;
        }
        CooldownManager.setCooldown(player.getUniqueId(), RTPConfig.getCooldown(world.getName()));
        int min = RTPConfig.getMinRadius(world.getName());
        int max = RTPConfig.getMaxRadius(world.getName());
        Random random = new Random();
        int x = random.nextInt(max - min + 1) + min;
        int z = random.nextInt(max - min + 1) + min;
        if (random.nextBoolean()) {
            x = -x;
        }
        if (random.nextBoolean()) {
            z = -z;
        }
        int y = world.getEnvironment() == World.Environment.NETHER ? 64 : world.getHighestBlockYAt(x, z) + 1;
        Location loc = new Location(world, (double)x + 0.5, (double)y, (double)z + 0.5);
        BackManager.setLastLocation(player.getUniqueId(), player.getLocation());
        player.closeInventory();
        player.getWorld().spawnParticle(Particle.PORTAL, player.getLocation(), 100, 1.0, 1.0, 1.0);
        player.playSound(player.getLocation(), Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            player.teleport(loc);
            player.sendMessage(messages.get("teleport-success", "{world}", world.getName()));
            world.spawnParticle(Particle.PORTAL, loc, 100, 1.0, 1.0, 1.0);
            world.playSound(loc, Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
        }, 40L);
        File rtpLogFile = new File(this.plugin.getDataFolder(), "rtplocations.yml");
        YamlConfiguration rtpLog = YamlConfiguration.loadConfiguration((File)rtpLogFile);
        rtpLog.set(player.getName(), (Object)(world.getName() + ": " + x + " " + y + " " + z));
        try {
            rtpLog.save(rtpLogFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent event) {
        BackManager.setLastLocation(event.getEntity().getUniqueId(), event.getEntity().getLocation());
    }
}

