/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.auction;

import net.lunark.io.ServerEssentials;
import net.lunark.io.auction.AuctionItem;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class AuctionCommand
implements CommandExecutor {
    private final ServerEssentials plugin;

    public AuctionCommand(ServerEssentials plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getAuctionMessagesManager().getMessage("command.only-players", new String[0]));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("serveressentials.ah.use")) {
            player.sendMessage(this.plugin.getAuctionMessagesManager().getMessage("command.no-permission", new String[0]));
            return true;
        }
        if (args.length == 0) {
            if (!player.hasPermission("serveressentials.ah.view")) {
                player.sendMessage(this.plugin.getAuctionMessagesManager().getMessage("command.no-permission", new String[0]));
                return true;
            }
            this.plugin.getGuiManager().openAuctionGUI(player, 1);
            return true;
        }
        if (args[0].equalsIgnoreCase("my")) {
            if (!player.hasPermission("serveressentials.ah.my")) {
                player.sendMessage(this.plugin.getAuctionMessagesManager().getMessage("command.no-permission", new String[0]));
                return true;
            }
            this.plugin.getGuiManager().openPlayerItemsGUI(player, 1);
            return true;
        }
        if (args[0].equalsIgnoreCase("sell")) {
            double price;
            if (!player.hasPermission("serveressentials.ah.sell")) {
                player.sendMessage(this.plugin.getAuctionMessagesManager().getMessage("command.no-permission", new String[0]));
                return true;
            }
            ItemStack handItem = player.getInventory().getItemInMainHand();
            if (handItem == null || handItem.getType().isAir()) {
                player.sendMessage(this.plugin.getAuctionMessagesManager().getMessage("command.sell.no-item", new String[0]));
                return true;
            }
            if (args.length < 2) {
                player.sendMessage(this.plugin.getAuctionMessagesManager().getMessage("command.sell.usage", new String[0]));
                return true;
            }
            try {
                price = Double.parseDouble(args[1]);
            }
            catch (NumberFormatException ex) {
                player.sendMessage(this.plugin.getAuctionMessagesManager().getMessage("command.sell.invalid-price", new String[0]));
                return true;
            }
            int maxSell = this.plugin.getConfig().getInt("serveressentials.auction.max-sell-limit", 64);
            if (handItem.getAmount() > maxSell) {
                player.sendMessage(this.plugin.getAuctionMessagesManager().getMessage("command.sell.max-limit", "%max%", String.valueOf(maxSell)));
                return true;
            }
            int expirationDays = this.plugin.getConfig().getInt("serveressentials.auction.expiration-days", 7);
            long expirationTime = System.currentTimeMillis() + (long)expirationDays * 24L * 60L * 60L * 1000L;
            player.getInventory().setItemInMainHand(null);
            this.plugin.getAuctionManager().addAuctionItem(new AuctionItem(player.getUniqueId(), handItem, price, expirationTime));
            player.sendMessage(this.plugin.getAuctionMessagesManager().getMessage("command.sell.success", "%price%", String.valueOf(price)));
            return true;
        }
        player.sendMessage(this.plugin.getAuctionMessagesManager().getMessage("command.usage", new String[0]));
        return true;
    }
}

