/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.auction;

import java.util.UUID;
import net.lunark.io.ServerEssentials;
import net.lunark.io.auction.AuctionItem;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class AuctionListeners
implements Listener {
    private final ServerEssentials plugin;

    public AuctionListeners(ServerEssentials plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        HumanEntity humanEntity = e.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        String title = e.getView().getTitle();
        if (!(title.contains("Auction House") || title.contains("Confirm Remove") || title.contains("Your Items"))) {
            return;
        }
        e.setCancelled(true);
        ItemStack clicked = e.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        if (title.contains("Confirm Remove")) {
            AuctionItem itemToRemove = this.plugin.getGuiManager().getItemToRemove(player);
            if (clicked.getType() == Material.GREEN_WOOL) {
                if (itemToRemove != null) {
                    player.getInventory().addItem(new ItemStack[]{itemToRemove.getItem().clone()});
                    this.plugin.getAuctionManager().removeAuctionItem(itemToRemove);
                    player.sendMessage(this.plugin.getAuctionMessagesManager().getMessage("remove.success", new String[0]));
                } else {
                    player.sendMessage(this.plugin.getAuctionMessagesManager().getMessage("remove.not-found", new String[0]));
                }
                this.plugin.getGuiManager().openPlayerItemsGUI(player, 1);
            } else if (clicked.getType() == Material.RED_WOOL) {
                player.sendMessage(this.plugin.getAuctionMessagesManager().getMessage("remove.cancel", new String[0]));
                this.plugin.getGuiManager().openPlayerItemsGUI(player, 1);
            }
            return;
        }
        switch (clicked.getType()) {
            case BARRIER: {
                player.closeInventory();
                break;
            }
            case ARROW: {
                int page = this.extractPage(title);
                if (clicked.getItemMeta().getDisplayName().contains("Next")) {
                    if (title.contains("Auction House")) {
                        this.plugin.getGuiManager().openAuctionGUI(player, page + 1);
                        break;
                    }
                    this.plugin.getGuiManager().openPlayerItemsGUI(player, page + 1);
                    break;
                }
                if (title.contains("Auction House")) {
                    this.plugin.getGuiManager().openAuctionGUI(player, Math.max(page - 1, 1));
                    break;
                }
                this.plugin.getGuiManager().openPlayerItemsGUI(player, Math.max(page - 1, 1));
                break;
            }
            case PAPER: {
                if (!title.contains("Auction House")) break;
                this.plugin.getGuiManager().openAuctionGUI(player, this.extractPage(title));
                player.sendMessage(this.plugin.getAuctionMessagesManager().getMessage("auction.refresh", new String[0]));
                break;
            }
            case CHEST: {
                if (!title.contains("Auction House")) break;
                this.plugin.getGuiManager().openPlayerItemsGUI(player, 1);
                break;
            }
            case PLAYER_HEAD: {
                if (!title.contains("Auction House")) break;
                double balance = this.plugin.getVaultEconomy().getBalance((OfflinePlayer)player);
                player.sendMessage(this.plugin.getAuctionMessagesManager().getMessage("auction.balance", "%balance%", String.valueOf(balance)));
            }
        }
        if (title.contains("Your Items")) {
            AuctionItem auctionItem = this.plugin.getGuiManager().getPlayerItem(player, e.getRawSlot());
            if (auctionItem != null) {
                this.plugin.getGuiManager().openRemoveConfirmGUI(player, auctionItem);
            }
            return;
        }
        if (title.contains("Auction House")) {
            AuctionItem auctionItem = this.plugin.getGuiManager().getAuctionItem(player, e.getRawSlot());
            if (auctionItem == null) {
                return;
            }
            double price = auctionItem.getPrice();
            if (this.plugin.getVaultEconomy().getBalance((OfflinePlayer)player) < price) {
                player.sendMessage(this.plugin.getAuctionMessagesManager().getMessage("auction.not-enough-money", new String[0]));
                return;
            }
            this.plugin.getVaultEconomy().withdrawPlayer((OfflinePlayer)player, price);
            UUID sellerUUID = auctionItem.getSeller();
            if (Bukkit.getOfflinePlayer((UUID)sellerUUID).isOnline()) {
                Player seller = Bukkit.getPlayer((UUID)sellerUUID);
                this.plugin.getVaultEconomy().depositPlayer((OfflinePlayer)seller, price);
                seller.sendMessage(this.plugin.getAuctionMessagesManager().getMessage("auction.sold", "%player%", player.getName(), "%price%", String.valueOf(price)));
            } else {
                this.plugin.getVaultEconomy().depositPlayer(Bukkit.getOfflinePlayer((UUID)sellerUUID), price);
            }
            player.getInventory().addItem(new ItemStack[]{auctionItem.getItem().clone()});
            player.sendMessage(this.plugin.getAuctionMessagesManager().getMessage("auction.purchase", "%price%", String.valueOf(price)));
            this.plugin.getAuctionManager().removeAuctionItem(auctionItem);
            this.plugin.getGuiManager().openAuctionGUI(player, this.extractPage(title));
        }
    }

    private int extractPage(String title) {
        if (!title.matches(".*Page \\d+.*")) {
            return 1;
        }
        return Integer.parseInt(title.replaceAll(".*Page (\\d+).*", "$1"));
    }
}

