/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.auction;

import java.io.File;
import java.io.IOException;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.lunark.io.ServerEssentials;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class AuctionMessagesManager {
    private static AuctionMessagesManager instance;
    private final ServerEssentials plugin;
    private File messagesFile;
    private FileConfiguration messagesConfig;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();

    public AuctionMessagesManager(ServerEssentials plugin) {
        this.plugin = plugin;
        instance = this;
        this.loadMessages();
    }

    public static AuctionMessagesManager getInstance() {
        return instance;
    }

    public void reload() {
        if (this.messagesFile == null) {
            this.loadMessages();
            return;
        }
        if (!this.messagesFile.exists()) {
            this.plugin.saveResource("messages/auction.yml", false);
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        Bukkit.getLogger().info("[ServerEssentials] AuctionMessagesManager reloaded successfully.");
    }

    public static void fullReload() {
        if (instance == null) {
            Bukkit.getLogger().warning("[ServerEssentials] Tried to reload AuctionMessagesManager before initialization!");
            return;
        }
        instance.reload();
    }

    public void loadMessages() {
        this.messagesFile = new File(this.plugin.getDataFolder(), "messages/auction.yml");
        if (!this.messagesFile.getParentFile().exists()) {
            this.messagesFile.getParentFile().mkdirs();
        }
        if (!this.messagesFile.exists()) {
            this.plugin.saveResource("messages/auction.yml", false);
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
    }

    public Component getMessage(String path, String ... placeholders) {
        String msg = this.messagesConfig.getString(path, "<red>Missing message for " + path);
        if (placeholders != null && placeholders.length % 2 == 0) {
            for (int i = 0; i < placeholders.length; i += 2) {
                msg = msg.replace(placeholders[i], placeholders[i + 1]);
            }
        }
        return this.miniMessage.deserialize(msg);
    }

    public void addDefault(String path, String defaultMessage) {
        if (!this.messagesConfig.contains(path)) {
            this.messagesConfig.set(path, (Object)defaultMessage);
            this.save();
        }
    }

    public void save() {
        try {
            this.messagesConfig.save(this.messagesFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public FileConfiguration getConfig() {
        return this.messagesConfig;
    }
}

