/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.config;

import java.io.File;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class RTPConfig {
    private static final File file = new File("plugins/ServerEssentials/config/rtp", "rtpconfig.yml");
    private static FileConfiguration config;

    public static void load() {
        RTPConfig.ensureFileExists();
        config = YamlConfiguration.loadConfiguration((File)file);
        RTPConfig.addDefaultsForMissingWorlds();
        RTPConfig.save();
    }

    public static void reload() {
        if (!file.exists()) {
            RTPConfig.load();
            return;
        }
        config = YamlConfiguration.loadConfiguration((File)file);
        RTPConfig.addDefaultsForMissingWorlds();
        RTPConfig.save();
        Bukkit.getLogger().info("[RTPConfig] Reloaded successfully.");
    }

    private static void ensureFileExists() {
        File parent = file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                Bukkit.getLogger().severe("[RTPConfig] Failed to create config file!");
                e.printStackTrace();
            }
        }
    }

    private static void addDefaultsForMissingWorlds() {
        for (World world : Bukkit.getWorlds()) {
            String name = world.getName();
            boolean updated = false;
            if (!config.contains(name + ".enabled")) {
                config.set(name + ".enabled", (Object)true);
                updated = true;
            }
            if (!config.contains(name + ".cooldown")) {
                config.set(name + ".cooldown", (Object)60);
                updated = true;
            }
            if (!config.contains(name + ".min-radius")) {
                config.set(name + ".min-radius", (Object)500);
                updated = true;
            }
            if (!config.contains(name + ".max-radius")) {
                config.set(name + ".max-radius", (Object)2000);
                updated = true;
            }
            if (!updated) continue;
        }
    }

    public static void fullReload() {
        RTPConfig.reload();
    }

    public static void save() {
        try {
            config.save(file);
        }
        catch (IOException e) {
            Bukkit.getLogger().severe("[RTPConfig] Failed to save!");
            e.printStackTrace();
        }
    }

    public static boolean isEnabled(String world) {
        return config.getBoolean(world + ".enabled", true);
    }

    public static int getCooldown(String world) {
        return config.getInt(world + ".cooldown", 60);
    }

    public static int getMinRadius(String world) {
        return config.getInt(world + ".min-radius", 500);
    }

    public static int getMaxRadius(String world) {
        return config.getInt(world + ".max-radius", 2000);
    }
}

