/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.database;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.bukkit.Bukkit;

public class DatabaseManager {
    private Connection connection;
    private final String type;
    private final String host;
    private final String database;
    private final String username;
    private final String password;
    private final int port;
    private final File dataFolder;

    public DatabaseManager(String type, String host, int port, String database, String username, String password, File dataFolder) {
        this.type = type.toLowerCase();
        this.host = host;
        this.port = port;
        this.database = database;
        this.username = username;
        this.password = password;
        this.dataFolder = dataFolder;
    }

    public void connect() throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            return;
        }
        if (this.type.equals("mysql")) {
            this.connection = DriverManager.getConnection("jdbc:mysql://" + this.host + ":" + this.port + "/" + this.database + "?useSSL=false&autoReconnect=true", this.username, this.password);
        } else if (this.type.equals("sqlite")) {
            File dbFile = new File(this.dataFolder, this.database + ".db");
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + dbFile.getAbsolutePath());
        } else {
            throw new SQLException("Unknown database type: " + this.type);
        }
    }

    public Connection getConnection() throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            this.connect();
        }
        return this.connection;
    }

    public void close() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void executeUpdate(String sql, Object ... params) {
        try (PreparedStatement ps = this.prepare(sql, params);){
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void executeUpdateAsync(String sql, Object ... params) {
        Bukkit.getScheduler().runTaskAsynchronously(Bukkit.getPluginManager().getPlugin("YourPluginName"), () -> this.executeUpdate(sql, params));
    }

    public void executeQuery(String sql, Consumer<ResultSet> consumer, Object ... params) {
        try (PreparedStatement ps = this.prepare(sql, params);
             ResultSet rs = ps.executeQuery();){
            consumer.accept(rs);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void executeQueryAsync(String sql, Consumer<ResultSet> consumer, Object ... params) {
        Bukkit.getScheduler().runTaskAsynchronously(Bukkit.getPluginManager().getPlugin("YourPluginName"), () -> this.executeQuery(sql, consumer, params));
    }

    public CompletableFuture<ResultSet> queryFuture(String sql, Object ... params) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                PreparedStatement ps = this.prepare(sql, params);
                return ps.executeQuery();
            }
            catch (SQLException e) {
                e.printStackTrace();
                return null;
            }
        });
    }

    private PreparedStatement prepare(String sql, Object ... params) throws SQLException {
        PreparedStatement ps = this.getConnection().prepareStatement(sql);
        for (int i = 0; i < params.length; ++i) {
            ps.setObject(i + 1, params[i]);
        }
        return ps;
    }
}

