/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.economy;

import java.io.File;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.lunark.io.ServerEssentials;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class BalanceCommand
implements CommandExecutor {
    private final Economy economy;
    private final MiniMessage mini = MiniMessage.miniMessage();
    private FileConfiguration messages;

    public BalanceCommand(Economy economy) {
        this.economy = economy;
        this.loadMessages();
    }

    private void loadMessages() {
        try {
            File file = new File(ServerEssentials.getInstance().getDataFolder(), "messages/economy.yml");
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                ServerEssentials.getInstance().saveResource("messages/economy.yml", false);
            }
            this.messages = YamlConfiguration.loadConfiguration((File)file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getMessage(String path, String def) {
        return this.messages.getString(path, def);
    }

    private Component parse(String message) {
        return this.mini.deserialize(message.replace("&", "\u00a7"));
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(this.parse(this.getMessage("only-players", "<red>Only players can check their own balance.")));
                return true;
            }
            Player player = (Player)sender;
            double balance = this.economy.getBalance((OfflinePlayer)player);
            String msg = this.getMessage("balance-self", "<green>Your balance is: <gold>$%balance%</gold>");
            msg = msg.replace("%balance%", String.format("%.2f", balance));
            player.sendMessage(this.parse(msg));
            return true;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[0]);
        if (target == null) {
            sender.sendMessage(this.parse(this.getMessage("player-not-found", "<red>Player not found.")));
            return true;
        }
        double balance = this.economy.getBalance(target);
        String msg = this.getMessage("balance-other", "<green>%player%'s balance is: <gold>$%balance%</gold>");
        msg = msg.replace("%player%", target.getName()).replace("%balance%", String.format("%.2f", balance));
        sender.sendMessage(this.parse(msg));
        return true;
    }
}

