/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.economy;

import java.io.File;
import java.io.IOException;
import net.lunark.io.ServerEssentials;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class BalanceStorage {
    private static File file;
    private static FileConfiguration config;
    private static final Economy economy;

    public static void init() {
        File storageFolder = new File(ServerEssentials.getInstance().getDataFolder(), "storage");
        if (!storageFolder.exists()) {
            storageFolder.mkdirs();
        }
        if (!(file = new File(storageFolder, "balances.yml")).exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        config = YamlConfiguration.loadConfiguration((File)file);
    }

    public static void saveAllBalances() {
        for (OfflinePlayer player : ServerEssentials.getInstance().getServer().getOfflinePlayers()) {
            double balance = economy.getBalance(player);
            config.set(player.getUniqueId().toString(), (Object)balance);
        }
        try {
            config.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        economy = ServerEssentials.getEconomy();
    }
}

