/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.economy;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.lunark.io.ServerEssentials;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class BalanceTopCommand
implements CommandExecutor {
    private final ServerEssentials plugin;
    private final Economy economy;
    private FileConfiguration messages;
    private final MiniMessage mm = MiniMessage.miniMessage();

    public BalanceTopCommand(ServerEssentials plugin, Economy economy) {
        this.plugin = plugin;
        this.economy = economy;
        this.loadMessages();
    }

    private void loadMessages() {
        File file = new File(String.valueOf(this.plugin.getDataFolder()) + "/messages", "economy.yml");
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            this.plugin.saveResource("messages/economy.yml", false);
        }
        this.messages = YamlConfiguration.loadConfiguration((File)file);
    }

    private Component msg(String path, Map<String, String> placeholders) {
        String raw = this.messages.getString(path, path);
        if (raw == null) {
            return Component.text(path);
        }
        if (placeholders != null) {
            for (Map.Entry<String, String> e : placeholders.entrySet()) {
                raw = raw.replace("%" + e.getKey() + "%", e.getValue());
            }
        }
        return this.mm.deserialize(raw);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        HashMap<UUID, Double> balances = new HashMap<UUID, Double>();
        for (OfflinePlayer p : Bukkit.getOfflinePlayers()) {
            balances.put(p.getUniqueId(), this.economy.getBalance(p));
        }
        ArrayList sorted = new ArrayList(balances.entrySet());
        sorted.sort((a, b) -> Double.compare((Double)b.getValue(), (Double)a.getValue()));
        int limit = this.messages.getInt("balancetop.limit", 5);
        sender.sendMessage(this.msg("balancetop.header", Map.of("limit", String.valueOf(limit))));
        int rank = 1;
        for (Map.Entry entry : sorted.subList(0, Math.min(limit, sorted.size()))) {
            OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)((UUID)entry.getKey()));
            String name = player.getName() != null ? player.getName() : "Unknown";
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("rank", String.valueOf(rank));
            placeholders.put("player", name);
            placeholders.put("balance", String.format("%.2f", entry.getValue()));
            sender.sendMessage(this.msg("balancetop.entry", placeholders));
            ++rank;
        }
        sender.sendMessage(this.msg("balancetop.footer", null));
        return true;
    }
}

