/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.economy;

import java.io.File;
import java.util.HashMap;
import java.util.UUID;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.lunark.io.ServerEssentials;
import net.lunark.io.economy.PayConfirmToggleCommand;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class PayCommand
implements CommandExecutor {
    private static final HashMap<UUID, PendingPayment> pendingPayments = new HashMap();
    private static final long CONFIRMATION_TIMEOUT = 15000L;
    private final FileConfiguration messagesConfig;
    private final MiniMessage mm = MiniMessage.miniMessage();
    private final Economy economy;

    public PayCommand(Economy economy) {
        this.economy = economy;
        File messagesFile = new File(ServerEssentials.getInstance().getDataFolder(), "messages/economy.yml");
        if (!messagesFile.exists()) {
            messagesFile.getParentFile().mkdirs();
            ServerEssentials.getInstance().saveResource("messages/economy.yml", false);
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)messagesFile);
    }

    private String formatWithPlaceholders(String path, Object ... placeholders) {
        String raw = this.messagesConfig.getString(path, path);
        if (placeholders.length % 2 != 0) {
            return raw;
        }
        for (int i = 0; i < placeholders.length; i += 2) {
            raw = raw.replace(String.valueOf(placeholders[i]), String.valueOf(placeholders[i + 1]));
        }
        return raw;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        double amount;
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.mm.deserialize(this.formatWithPlaceholders("pay.only-players", new Object[0])));
            return true;
        }
        Player senderPlayer = (Player)sender;
        if (args.length != 2) {
            senderPlayer.sendMessage(this.mm.deserialize(this.formatWithPlaceholders("pay.usage", "%command%", "/pay")));
            return true;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[0]);
        if (target == null || !target.hasPlayedBefore() && !target.isOnline()) {
            senderPlayer.sendMessage(this.mm.deserialize(this.formatWithPlaceholders("pay.player-not-found", new Object[0])));
            return true;
        }
        if (target.getUniqueId().equals(senderPlayer.getUniqueId())) {
            senderPlayer.sendMessage(this.mm.deserialize(this.formatWithPlaceholders("pay.self-payment", new Object[0])));
            return true;
        }
        try {
            amount = Double.parseDouble(args[1]);
        }
        catch (NumberFormatException e) {
            senderPlayer.sendMessage(this.mm.deserialize(this.formatWithPlaceholders("pay.invalid-amount", new Object[0])));
            return true;
        }
        if (amount <= 0.0) {
            senderPlayer.sendMessage(this.mm.deserialize(this.formatWithPlaceholders("pay.positive-amount", new Object[0])));
            return true;
        }
        if (this.economy.getBalance((OfflinePlayer)senderPlayer) < amount) {
            senderPlayer.sendMessage(this.mm.deserialize(this.formatWithPlaceholders("pay.not-enough", new Object[0])));
            return true;
        }
        if (target.isOnline() && PayConfirmToggleCommand.hasConfirmationsDisabled((Player)target)) {
            senderPlayer.sendMessage(this.mm.deserialize(this.formatWithPlaceholders("pay.target-disabled", new Object[0])));
            return true;
        }
        UUID senderUUID = senderPlayer.getUniqueId();
        if (!PayConfirmToggleCommand.hasConfirmationsDisabled(senderPlayer)) {
            if (pendingPayments.containsKey(senderUUID)) {
                PendingPayment pending = pendingPayments.get(senderUUID);
                if (System.currentTimeMillis() - pending.timestamp > 15000L) {
                    pendingPayments.remove(senderUUID);
                    senderPlayer.sendMessage(this.mm.deserialize(this.formatWithPlaceholders("pay.confirmation-expired", new Object[0])));
                    return true;
                }
                if (pending.target.equals(target.getUniqueId()) && pending.amount == amount) {
                    pendingPayments.remove(senderUUID);
                    this.processPayment(senderPlayer, target, amount);
                    return true;
                }
                senderPlayer.sendMessage(this.mm.deserialize(this.formatWithPlaceholders("pay.pending-other", "%player%", Bukkit.getOfflinePlayer((UUID)pending.target).getName(), "%amount%", this.economy.format(pending.amount))));
                return true;
            }
            pendingPayments.put(senderUUID, new PendingPayment(target.getUniqueId(), amount));
            senderPlayer.sendMessage(this.mm.deserialize(this.formatWithPlaceholders("pay.confirm-message", "%player%", target.getName(), "%amount%", this.economy.format(amount))));
            senderPlayer.sendMessage(this.mm.deserialize(this.formatWithPlaceholders("pay.confirm-instruction", "%player%", target.getName(), "%amount%", this.economy.format(amount))));
            return true;
        }
        this.processPayment(senderPlayer, target, amount);
        return true;
    }

    private void processPayment(Player senderPlayer, OfflinePlayer target, double amount) {
        this.economy.withdrawPlayer((OfflinePlayer)senderPlayer, amount);
        this.economy.depositPlayer(target, amount);
        senderPlayer.sendMessage(this.mm.deserialize(this.formatWithPlaceholders("pay.success-sender", "%player%", target.getName(), "%amount%", this.economy.format(amount))));
        if (target.isOnline()) {
            ((Player)target).sendMessage(this.mm.deserialize(this.formatWithPlaceholders("pay.success-target", "%player%", senderPlayer.getName(), "%amount%", this.economy.format(amount))));
        }
    }

    private static class PendingPayment {
        private final UUID target;
        private final double amount;
        private final long timestamp;

        public PendingPayment(UUID target, double amount) {
            this.target = target;
            this.amount = amount;
            this.timestamp = System.currentTimeMillis();
        }
    }
}

