/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.kit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.lunark.io.ServerEssentials;
import net.lunark.io.kit.KitCommand;
import net.lunark.io.kit.KitConfigManager;
import net.lunark.io.kit.KitManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class KitGUIListener
implements Listener {
    private final KitCommand kitCommand;
    private static final Pattern HEX_PATTERN = Pattern.compile("<#([A-Fa-f0-9]{6})>");

    public KitGUIListener(KitCommand command) {
        this.kitCommand = command;
    }

    private void openKitPreview(Player player, String kitId) {
        FileConfiguration config = KitConfigManager.getConfig();
        List itemList = config.getStringList("kits." + kitId + ".items");
        Inventory preview = Bukkit.createInventory(null, (int)54, (String)this.formatColors("<#FFFFFF>Preview Kit: " + kitId));
        int slot = 0;
        for (String itemStr : itemList) {
            ItemStack item = KitManager.parseItemString(itemStr);
            if (item == null || slot >= 54) continue;
            preview.setItem(slot++, item);
        }
        ItemStack claim = new ItemStack(Material.LIME_CONCRETE);
        ItemMeta claimMeta = claim.getItemMeta();
        if (claimMeta != null) {
            claimMeta.setDisplayName(this.formatColors("<#1BFF00>Claim Kit"));
            claimMeta.getPersistentDataContainer().set(new NamespacedKey((Plugin)ServerEssentials.getInstance(), "kitName"), PersistentDataType.STRING, (Object)kitId.toLowerCase(Locale.ROOT));
            claim.setItemMeta(claimMeta);
        }
        preview.setItem(53, claim);
        ItemStack back = new ItemStack(Material.BARRIER);
        ItemMeta backMeta = back.getItemMeta();
        if (backMeta != null) {
            backMeta.setDisplayName(this.formatColors("<#FF0000>Back"));
            back.setItemMeta(backMeta);
        }
        preview.setItem(45, back);
        player.openInventory(preview);
    }

    public void openKitGUI(Player player) {
        Inventory gui = Bukkit.createInventory(null, (int)54, (Component)ServerEssentials.getInstance().getKitMessages().get("gui-title", "%player%", player.getName()));
        FileConfiguration config = KitConfigManager.getConfig();
        ConfigurationSection kitsSec = config.getConfigurationSection("kits");
        if (kitsSec == null) {
            player.sendMessage(ServerEssentials.getInstance().getKitMessages().get("no-kits-defined", "%player%", player.getName()));
            return;
        }
        int auto = 0;
        for (String kitId : kitsSec.getKeys(false)) {
            ItemStack icon;
            String permission = kitsSec.getString(kitId + ".permission");
            boolean hasPermission = permission == null || permission.isEmpty() || player.hasPermission(permission);
            int slot = kitsSec.getInt(kitId + ".display.slot", kitsSec.getInt(kitId + ".slot", auto));
            if (slot < 0 || slot >= 54) {
                slot = auto;
            }
            auto = this.nextEmpty(gui, slot);
            String matName = kitsSec.getString(kitId + ".display.material", "SHULKER_BOX");
            Material mat = Material.matchMaterial((String)matName.toUpperCase(Locale.ROOT));
            if (mat == null) {
                mat = Material.SHULKER_BOX;
            }
            if (hasPermission) {
                icon = new ItemStack(mat);
                meta = icon.getItemMeta();
                if (meta != null) {
                    rawName = kitsSec.getString(kitId + ".display.name", kitId);
                    meta.setDisplayName(this.formatColors(rawName));
                    lore = new ArrayList<String>();
                    for (String raw : kitsSec.getStringList(kitId + ".display.lore")) {
                        lore.add(this.formatColors(raw));
                    }
                    meta.setLore(lore);
                    icon.setItemMeta(meta);
                }
            } else {
                icon = new ItemStack(Material.BARRIER);
                meta = icon.getItemMeta();
                if (meta != null) {
                    rawName = kitsSec.getString(kitId + ".display.name", kitId);
                    meta.setDisplayName(this.formatColors("<#FF0000>Locked: <#AAAAAA>" + rawName));
                    lore = new ArrayList();
                    lore.add(this.formatColors("<#AAAAAA>You don't have permission to use this kit."));
                    if (permission != null && !permission.isEmpty()) {
                        lore.add(this.formatColors("<#AAAAAA>Required: <#FFFFFF>" + permission));
                    }
                    long now = System.currentTimeMillis();
                    Map cooldowns = this.kitCommand.getCooldowns().getOrDefault(player.getUniqueId(), new HashMap());
                    long lastUsed = cooldowns.getOrDefault(kitId.toLowerCase(Locale.ROOT), 0L);
                    long cooldown = kitsSec.getLong(kitId + ".cooldown", 0L);
                    long remaining = cooldown - (now - lastUsed) / 1000L;
                    if (remaining > 0L) {
                        lore.add(this.formatColors("<#AAAAAA>Cooldown: <#FF0000>" + remaining + "s remaining"));
                    }
                    meta.setLore(lore);
                    icon.setItemMeta(meta);
                }
            }
            icon = this.applyCustomTag(icon, "kitName", kitId);
            gui.setItem(slot, icon);
        }
        player.openInventory(gui);
    }

    private int nextEmpty(Inventory inv, int start) {
        int i;
        for (i = start; i < inv.getSize(); ++i) {
            if (inv.getItem(i) != null && inv.getItem(i).getType() != Material.AIR) continue;
            return i;
        }
        for (i = 0; i < inv.getSize(); ++i) {
            if (inv.getItem(i) != null && inv.getItem(i).getType() != Material.AIR) continue;
            return i;
        }
        return 0;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity clicker = event.getWhoClicked();
        if (!(clicker instanceof Player)) {
            return;
        }
        Player player = (Player)clicker;
        Inventory clickedInv = event.getClickedInventory();
        Inventory topInv = event.getView().getTopInventory();
        if (clickedInv == null || clickedInv != topInv) {
            return;
        }
        String title = event.getView().getTitle();
        boolean kitsMenu = title.contains("Available Kits");
        boolean previewMenu = title.contains("Preview Kit: ");
        if (!kitsMenu && !previewMenu) {
            return;
        }
        event.setCancelled(true);
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR || !clicked.hasItemMeta()) {
            return;
        }
        if (kitsMenu) {
            String kitId = this.getCustomTag(clicked, "kitName");
            if (kitId == null) {
                return;
            }
            String permission = KitConfigManager.getConfig().getString("kits." + kitId + ".permission");
            if (permission != null && !permission.isEmpty() && !player.hasPermission(permission)) {
                player.sendMessage(ServerEssentials.getInstance().getKitMessages().get("claim.no-permission", "%kit%", kitId, "%player%", player.getName()));
                return;
            }
            this.openKitPreview(player, kitId);
            return;
        }
        if (previewMenu) {
            if (clicked.getType() == Material.LIME_CONCRETE) {
                String kitId = this.getCustomTag(clicked, "kitName");
                if (kitId != null) {
                    this.claimKit(player, kitId);
                }
                player.closeInventory();
            } else if (clicked.getType() == Material.BARRIER) {
                this.openKitGUI(player);
            }
        }
    }

    private void claimKit(Player player, String kitId) {
        Map playerCooldowns;
        long lastUsed;
        FileConfiguration config = KitConfigManager.getConfig();
        String perm = config.getString("kits." + kitId + ".permission");
        int cooldown = config.getInt("kits." + kitId + ".cooldown", 0);
        if (perm != null && !perm.isEmpty() && !player.hasPermission(perm)) {
            player.sendMessage(ServerEssentials.getInstance().getKitMessages().get("claim.no-permission", "%kit%", kitId, "%player%", player.getName(), "%permission%", perm));
            return;
        }
        long now = System.currentTimeMillis();
        long diff = (now - (lastUsed = (playerCooldowns = this.kitCommand.getCooldowns().computeIfAbsent(player.getUniqueId(), k -> new HashMap())).getOrDefault(kitId.toLowerCase(Locale.ROOT), 0L).longValue())) / 1000L;
        if (diff < (long)cooldown) {
            player.sendMessage(ServerEssentials.getInstance().getKitMessages().get("claim.cooldown", "%kit%", kitId, "%player%", player.getName(), "%time%", String.valueOf((long)cooldown - diff)));
            return;
        }
        List itemList = config.getStringList("kits." + kitId + ".items");
        for (String s : itemList) {
            ItemStack it = KitManager.parseItemString(s);
            if (it == null) continue;
            player.getInventory().addItem(new ItemStack[]{it});
        }
        playerCooldowns.put(kitId.toLowerCase(Locale.ROOT), now);
        this.kitCommand.getCooldowns().put(player.getUniqueId(), playerCooldowns);
        player.sendMessage(ServerEssentials.getInstance().getKitMessages().get("claim.success", "%kit%", kitId, "%player%", player.getName()));
    }

    private String formatColors(String input) {
        if (input == null) {
            return "";
        }
        Matcher matcher = HEX_PATTERN.matcher(input);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String hexCode = matcher.group(1);
            net.md_5.bungee.api.ChatColor hexColor = net.md_5.bungee.api.ChatColor.of((String)("#" + hexCode));
            matcher.appendReplacement(buffer, hexColor.toString());
        }
        matcher.appendTail(buffer);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)buffer.toString());
    }

    private ItemStack applyCustomTag(ItemStack item, String key, String value) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        NamespacedKey namespacedKey = new NamespacedKey((Plugin)ServerEssentials.getInstance(), key.toLowerCase(Locale.ROOT));
        meta.getPersistentDataContainer().set(namespacedKey, PersistentDataType.STRING, (Object)value.toLowerCase(Locale.ROOT));
        item.setItemMeta(meta);
        return item;
    }

    private String getCustomTag(ItemStack item, String key) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return null;
        }
        NamespacedKey namespacedKey = new NamespacedKey((Plugin)ServerEssentials.getInstance(), key.toLowerCase(Locale.ROOT));
        return (String)meta.getPersistentDataContainer().get(namespacedKey, PersistentDataType.STRING);
    }
}

