/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.scoreboard;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class ScoreboardStorage {
    private final File file;
    private YamlConfiguration config;
    private final Map<UUID, Boolean> scoreboardStates = new HashMap<UUID, Boolean>();

    public ScoreboardStorage(JavaPlugin plugin) {
        this.file = new File(plugin.getDataFolder(), "storage/scoreboard.yml");
        this.reload();
        this.loadCachedStates();
    }

    public void reload() {
        if (!this.file.exists()) {
            this.file.getParentFile().mkdirs();
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        this.loadCachedStates();
    }

    private void loadCachedStates() {
        this.scoreboardStates.clear();
        if (this.config.isConfigurationSection("players")) {
            for (String uuidStr : this.config.getConfigurationSection("players").getKeys(false)) {
                boolean enabled = this.config.getBoolean("players." + uuidStr + ".enabled", true);
                try {
                    this.scoreboardStates.put(UUID.fromString(uuidStr), enabled);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        for (Player p : Bukkit.getOnlinePlayers()) {
            UUID id = p.getUniqueId();
            this.scoreboardStates.putIfAbsent(id, true);
        }
        this.scoreboardStates.keySet().removeIf(uuid -> Bukkit.getPlayer((UUID)uuid) == null);
    }

    public void setEnabled(Player player, boolean enabled) {
        UUID uuid = player.getUniqueId();
        this.scoreboardStates.put(uuid, enabled);
        this.config.set("players." + String.valueOf(uuid) + ".enabled", (Object)enabled);
        this.save();
    }

    void setCachedState(UUID uuid, boolean enabled) {
        this.scoreboardStates.put(uuid, enabled);
    }

    void removeCachedState(UUID uuid) {
        this.scoreboardStates.remove(uuid);
    }

    public boolean togglePlayer(Player player) {
        UUID uuid = player.getUniqueId();
        boolean newState = !this.isEnabled(player);
        this.scoreboardStates.put(uuid, newState);
        this.config.set("players." + String.valueOf(uuid) + ".enabled", (Object)newState);
        this.save();
        return newState;
    }

    public boolean isEnabled(Player player) {
        return this.scoreboardStates.getOrDefault(player.getUniqueId(), true);
    }

    public void setPlayerLayout(Player player, String layout) {
        this.config.set("players." + String.valueOf(player.getUniqueId()) + ".layout", (Object)layout);
        this.save();
    }

    public String getPlayerLayout(Player player) {
        return this.config.getString("players." + String.valueOf(player.getUniqueId()) + ".layout", "default");
    }

    private void save() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

