/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.scoreboard;

import java.util.List;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.lunark.io.scoreboard.CustomScoreboardManager;
import net.lunark.io.scoreboard.util.PlaceholderUtil;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class ScoreboardUpdater {
    private final CustomScoreboardManager manager;
    private final MiniMessage mini = MiniMessage.miniMessage();

    public ScoreboardUpdater(CustomScoreboardManager manager) {
        this.manager = manager;
    }

    public void start() {
        new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (ScoreboardUpdater.this.manager.getStorage().isEnabled(player)) {
                        ScoreboardUpdater.this.update(player);
                        continue;
                    }
                    ScoreboardUpdater.this.clear(player);
                }
            }
        }.runTaskTimer((Plugin)this.manager.getPlugin(), 20L, 20L);
    }

    public void refreshAll() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (this.manager.getStorage().isEnabled(player)) {
                this.update(player);
                continue;
            }
            this.clear(player);
        }
    }

    public void clear(Player player) {
        player.setScoreboard(Bukkit.getScoreboardManager().getNewScoreboard());
    }

    public void update(Player player) {
        if (!this.manager.getStorage().isEnabled(player)) {
            this.clear(player);
            return;
        }
        String layout = this.manager.getConfigHandler().getLayoutForPlayer(player, this.manager.getStorage());
        this.update(player, layout);
    }

    public void update(Player player, String layout) {
        Objective obj;
        if (!this.manager.getStorage().isEnabled(player)) {
            this.clear(player);
            return;
        }
        String world = player.getWorld().getName();
        if (!this.manager.getConfigHandler().isWorldEnabled(world)) {
            this.clear(player);
            return;
        }
        String title = PlaceholderUtil.apply(player, this.manager.getConfigHandler().getTitle(layout));
        List<String> lines = this.manager.getConfigHandler().getLines(layout);
        Scoreboard board = player.getScoreboard();
        if (board == Bukkit.getScoreboardManager().getMainScoreboard() || board == null) {
            board = Bukkit.getScoreboardManager().getNewScoreboard();
        }
        if ((obj = board.getObjective("sidebar")) == null) {
            obj = board.registerNewObjective("sidebar", "dummy", this.mini.deserialize(title));
            obj.setDisplaySlot(DisplaySlot.SIDEBAR);
        } else {
            obj.displayName(this.mini.deserialize(title));
        }
        int score = lines.size();
        for (String entry : board.getEntries()) {
            if (!entry.startsWith("\u00a7") || Integer.parseInt(entry.substring(1)) < lines.size()) continue;
            board.resetScores(entry);
            Team t = board.getTeam("line" + entry.substring(1));
            if (t == null) continue;
            t.unregister();
        }
        for (int i = 0; i < lines.size(); ++i) {
            String replaced = PlaceholderUtil.apply(player, lines.get(i));
            String entry = "\u00a7" + i;
            Team team = board.getTeam("line" + i);
            if (team == null) {
                team = board.registerNewTeam("line" + i);
            }
            if (!team.hasEntry(entry)) {
                team.addEntry(entry);
            }
            team.prefix(this.mini.deserialize(replaced));
            obj.getScore(entry).setScore(score--);
        }
        player.setScoreboard(board);
    }
}

