/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.scoreboard.util;

import java.io.File;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class MessageUtil {
    private final JavaPlugin plugin;
    private final String path;
    private File file;
    private YamlConfiguration config;

    public MessageUtil(JavaPlugin plugin, String path) {
        this.plugin = plugin;
        this.path = path;
        this.reload();
    }

    public void reload() {
        this.file = new File(this.plugin.getDataFolder(), this.path);
        if (!this.file.exists()) {
            this.file.getParentFile().mkdirs();
            this.plugin.saveResource(this.path, false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public void send(Player player, String path, String ... replacements) {
        String msg = this.config.getString(path, "<red>Missing message: " + path);
        for (int i = 0; i < replacements.length; i += 2) {
            msg = msg.replace(replacements[i], replacements[i + 1]);
        }
        player.sendMessage(MiniMessage.miniMessage().deserialize(msg));
    }
}

