/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.server;

import net.lunark.io.util.ServerMessages;
import org.bukkit.Bukkit;
import org.bukkit.WorldCreator;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class LoadWorldCommand
implements CommandExecutor {
    private final ServerMessages messages;

    public LoadWorldCommand(ServerMessages messages) {
        this.messages = messages;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        boolean loaded;
        if (!sender.hasPermission("serveressentials.loadworld")) {
            sender.sendMessage(this.messages.get("loadworld.no-permission"));
            return true;
        }
        if (args.length != 1) {
            sender.sendMessage(this.messages.get("loadworld.usage"));
            return true;
        }
        String worldName = args[0];
        if (Bukkit.getWorld((String)worldName) != null) {
            sender.sendMessage(this.messages.get("loadworld.already-loaded", "<world>", worldName));
            return true;
        }
        boolean bl = loaded = Bukkit.getServer().createWorld(new WorldCreator(worldName)) != null;
        if (loaded) {
            sender.sendMessage(this.messages.get("loadworld.success", "<world>", worldName));
        } else {
            sender.sendMessage(this.messages.get("loadworld.failed", "<world>", worldName));
        }
        return true;
    }
}

