/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.server;

import java.time.Duration;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import net.lunark.io.util.ServerMessages;
import org.bukkit.Bukkit;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class RebootCommand
implements CommandExecutor {
    private final JavaPlugin plugin;
    private final ServerMessages messages;

    public RebootCommand(JavaPlugin plugin, ServerMessages messages) {
        this.plugin = plugin;
        this.messages = messages;
        messages.addDefault("reboot.usage", "<red>Usage: /reboot <minutes>");
        messages.addDefault("reboot.announce-scheduled", "<red>\u26a0 Server will reboot in <time> minute(s).");
        messages.addDefault("reboot.announce-minutes", "<yellow>\u23f3 Reboot in <time> minute(s).");
        messages.addDefault("reboot.announce-seconds", "<gold>\u23f3 Reboot in <time> second(s).");
        messages.addDefault("reboot.announce-now", "<red><bold>\u26a0 Rebooting now!");
        messages.addDefault("titles.minute-warning", "<yellow>\u23f3 Reboot in <time> minute(s).");
        messages.addDefault("titles.second-warning", "<gold><bold><time></bold>");
        messages.addDefault("titles.reboot-now", "<red><bold>\u26a0 Rebooting now!");
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        int minutes;
        if (args.length != 1) {
            sender.sendMessage(this.messages.get("reboot.usage"));
            return true;
        }
        try {
            minutes = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException e) {
            sender.sendMessage(this.messages.get("reboot.usage"));
            return true;
        }
        final int seconds = minutes * 60;
        this.broadcastMessage("reboot.announce-scheduled", minutes);
        new BukkitRunnable(){
            int remaining;
            {
                this.remaining = seconds;
            }

            public void run() {
                if (this.remaining == 0) {
                    RebootCommand.this.broadcastMessage("reboot.announce-now", 0);
                    RebootCommand.this.broadcastTitle("titles.reboot-now", 0, Duration.ofSeconds(2L));
                    RebootCommand.this.playEffects();
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)"stop");
                    this.cancel();
                    return;
                }
                if (this.remaining == 3600 || this.remaining == 1800 || this.remaining == 600 || this.remaining == 300 || this.remaining == 60) {
                    RebootCommand.this.broadcastMessage("reboot.announce-minutes", this.remaining / 60);
                    RebootCommand.this.broadcastTitle("titles.minute-warning", this.remaining / 60, Duration.ofSeconds(2L));
                }
                if (this.remaining <= 3 && this.remaining > 0) {
                    RebootCommand.this.broadcastMessage("reboot.announce-seconds", this.remaining);
                    RebootCommand.this.broadcastTitle("titles.second-warning", this.remaining, Duration.ofSeconds(2L));
                    RebootCommand.this.playEffects();
                }
                --this.remaining;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
        return true;
    }

    private void broadcastMessage(String path, int time) {
        Component msg = this.messages.get(path).replaceText(builder -> builder.match("<time>").replacement(String.valueOf(time)));
        Bukkit.broadcast((Component)msg);
    }

    private void broadcastTitle(String path, int time, Duration stay) {
        Component title = this.messages.get(path).replaceText(builder -> builder.match("<time>").replacement(String.valueOf(time)));
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.showTitle(Title.title(title, Component.empty(), Title.Times.times(Duration.ofMillis(500L), stay, Duration.ofMillis(500L))));
        }
    }

    private void playEffects() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.playSound(player.getLocation(), Sound.ENTITY_ENDER_DRAGON_GROWL, 1.0f, 1.0f);
            player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 1.0f, 2.0f);
            player.spawnParticle(Particle.FIREWORK, player.getLocation().add(0.0, 1.0, 0.0), 30, 0.5, 0.5, 0.5, 0.1);
        }
    }
}

