/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.lunark.io.util.ServerMessages;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class SpawnerCommand
implements CommandExecutor,
TabCompleter {
    private final ServerMessages messages;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();

    public SpawnerCommand(ServerMessages messages) {
        this.messages = messages;
        messages.addDefault("Spawner.PlayerOnly", "<red>Only players can use this command!");
        messages.addDefault("Spawner.NoPermission", "<red>You don\u2019t have permission to set a spawner to {mob}!");
        messages.addDefault("Spawner.LookAtSpawner", "<red>Look at a spawner to change it!");
        messages.addDefault("Spawner.Usage", "<yellow>Usage: /spawner <mob>");
        messages.addDefault("Spawner.InvalidMob", "<red>Invalid mob type: {mob}");
        messages.addDefault("Spawner.Changed", "<green>Spawner type changed to {mob}");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        BlockState blockState;
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.messages.get("Spawner.PlayerOnly"));
            return true;
        }
        Player player = (Player)sender;
        if (player.getTargetBlockExact(5) != null && (blockState = player.getTargetBlockExact(5).getState()) instanceof CreatureSpawner) {
            CreatureSpawner spawner = (CreatureSpawner)blockState;
            if (args.length > 0) {
                String mobName = args[0].toUpperCase(Locale.ROOT);
                try {
                    EntityType type = EntityType.valueOf((String)mobName);
                    if (!player.hasPermission("serveressentials.spawner.*") && !player.hasPermission("serveressentials.spawner." + mobName.toLowerCase(Locale.ROOT))) {
                        sender.sendMessage(this.miniMessage.deserialize(this.messages.getConfig().getString("Spawner.NoPermission").replace("{mob}", mobName.toLowerCase(Locale.ROOT))));
                        return true;
                    }
                    spawner.setSpawnedType(type);
                    spawner.update();
                    sender.sendMessage(this.miniMessage.deserialize(this.messages.getConfig().getString("Spawner.Changed").replace("{mob}", mobName.toLowerCase(Locale.ROOT))));
                }
                catch (IllegalArgumentException e) {
                    sender.sendMessage(this.miniMessage.deserialize(this.messages.getConfig().getString("Spawner.InvalidMob").replace("{mob}", args[0])));
                }
            } else {
                sender.sendMessage(this.messages.get("Spawner.Usage"));
            }
        } else {
            sender.sendMessage(this.messages.get("Spawner.LookAtSpawner"));
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> suggestions = new ArrayList<String>();
        if (!(sender instanceof Player)) {
            return suggestions;
        }
        Player player = (Player)sender;
        if (args.length == 1) {
            for (EntityType type : EntityType.values()) {
                String mobName = type.name().toLowerCase(Locale.ROOT);
                if (!type.isAlive() || !player.hasPermission("serveressentials.spawner.*") && !player.hasPermission("serveressentials.spawner." + mobName)) continue;
                suggestions.add(mobName);
            }
        }
        return suggestions;
    }
}

