/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.staff;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.lunark.io.ServerEssentials;
import net.lunark.io.util.MessagesManager;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;

public class AdminUtilitiesCommand
implements CommandExecutor,
TabCompleter {
    private final Set<Player> vanished = new HashSet<Player>();
    private final Set<Player> godMode = new HashSet<Player>();
    private static final MiniMessage miniMessage = MiniMessage.miniMessage();

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        MessagesManager messages = ServerEssentials.getInstance().getMessagesManager();
        if (!(sender instanceof Player)) {
            sender.sendMessage(messages.getMessageComponent("adminutilities.only-players", new String[0]));
            return true;
        }
        Player player = (Player)sender;
        switch (label.toLowerCase()) {
            case "vanish": {
                if (this.vanished.contains(player)) {
                    this.vanished.remove(player);
                    for (Player p : Bukkit.getOnlinePlayers()) {
                        p.showPlayer((Plugin)ServerEssentials.getInstance(), player);
                    }
                    player.sendMessage(messages.getMessageComponent("adminutilities.vanish.visible", new String[0]));
                    break;
                }
                this.vanished.add(player);
                for (Player p : Bukkit.getOnlinePlayers()) {
                    p.hidePlayer((Plugin)ServerEssentials.getInstance(), player);
                }
                player.sendMessage(messages.getMessageComponent("adminutilities.vanish.vanished", new String[0]));
                break;
            }
            case "god": {
                if (this.godMode.contains(player)) {
                    this.godMode.remove(player);
                    player.sendMessage(messages.getMessageComponent("adminutilities.god.disabled", new String[0]));
                    break;
                }
                this.godMode.add(player);
                player.sendMessage(messages.getMessageComponent("adminutilities.god.enabled", new String[0]));
                break;
            }
            case "invsee": {
                if (args.length < 1) {
                    player.sendMessage(messages.getMessageComponent("adminutilities.invsee.usage", new String[0]));
                    return true;
                }
                Player target = Bukkit.getPlayer((String)args[0]);
                if (target == null) {
                    player.sendMessage(messages.getMessageComponent("adminutilities.player-not-found", new String[0]));
                    return true;
                }
                player.openInventory((Inventory)target.getInventory());
                player.sendMessage(messages.getMessageComponent("adminutilities.invsee.success", "%target%", target.getName()));
                break;
            }
            case "invclear": {
                Player target = player;
                if (args.length >= 1 && (target = Bukkit.getPlayer((String)args[0])) == null) {
                    player.sendMessage(messages.getMessageComponent("adminutilities.player-not-found", new String[0]));
                    return true;
                }
                target.getInventory().clear();
                target.sendMessage(messages.getMessageComponent("adminutilities.invclear.cleared", new String[0]));
                if (target.equals((Object)player)) break;
                player.sendMessage(messages.getMessageComponent("adminutilities.invclear.cleared-other", "%target%", target.getName()));
                break;
            }
            case "tp": {
                if (args.length < 1) {
                    player.sendMessage(messages.getMessageComponent("adminutilities.tp.usage", new String[0]));
                    return true;
                }
                Player target = Bukkit.getPlayer((String)args[0]);
                if (target == null) {
                    player.sendMessage(messages.getMessageComponent("adminutilities.player-not-found", new String[0]));
                    return true;
                }
                player.teleport((Entity)target);
                player.sendMessage(messages.getMessageComponent("adminutilities.tp.success", "%target%", target.getName()));
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!(sender instanceof Player)) {
            return Collections.emptyList();
        }
        if ((alias.equalsIgnoreCase("tp") || alias.equalsIgnoreCase("invsee") || alias.equalsIgnoreCase("invclear")) && args.length == 1) {
            String input = args[0].toLowerCase();
            ArrayList<String> matches = new ArrayList<String>();
            for (Player online : Bukkit.getOnlinePlayers()) {
                if (!online.getName().toLowerCase().startsWith(input)) continue;
                matches.add(online.getName());
            }
            return matches;
        }
        return Collections.emptyList();
    }

    public boolean isGodMode(Player player) {
        return this.godMode.contains(player);
    }

    public boolean isVanished(Player player) {
        return this.vanished.contains(player);
    }
}

