/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.staff;

import java.util.HashSet;
import java.util.Set;
import net.lunark.io.util.MessagesManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;

public class FreezeCommand
implements CommandExecutor,
Listener {
    public static final Set<Player> frozenPlayers = new HashSet<Player>();
    private final MessagesManager messages;

    public FreezeCommand(MessagesManager messages, Plugin plugin) {
        this.messages = messages;
        Bukkit.getPluginManager().registerEvents((Listener)this, plugin);
        messages.addDefault("freeze.only-players", "<red>Only players can use this command.");
        messages.addDefault("freeze.usage", "<red>Usage: /freeze <player>");
        messages.addDefault("freeze.not-found", "<red>Player not found or not online.");
        messages.addDefault("freeze.froze", "<green>Froze <white>{player}</white>.");
        messages.addDefault("freeze.unfroze", "<yellow>Unfroze <white>{player}</white>.");
        messages.addDefault("freeze.you-frozen", "<red>You have been frozen!");
        messages.addDefault("freeze.you-unfrozen", "<green>You have been unfrozen.");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.messages.getMessageComponent("freeze.only-players", new String[0]));
            return true;
        }
        Player player = (Player)sender;
        if (args.length != 1) {
            player.sendMessage(this.messages.getMessageComponent("freeze.usage", new String[0]));
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null || !target.isOnline()) {
            player.sendMessage(this.messages.getMessageComponent("freeze.not-found", new String[0]));
            return true;
        }
        if (frozenPlayers.contains(target)) {
            frozenPlayers.remove(target);
            player.sendMessage(this.messages.getMessageComponent("freeze.unfroze", "{player}", target.getName()));
            target.sendMessage(this.messages.getMessageComponent("freeze.you-unfrozen", new String[0]));
        } else {
            frozenPlayers.add(target);
            player.sendMessage(this.messages.getMessageComponent("freeze.froze", "{player}", target.getName()));
            target.sendMessage(this.messages.getMessageComponent("freeze.you-frozen", new String[0]));
        }
        return true;
    }

    @EventHandler
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        if (frozenPlayers.contains(event.getPlayer())) {
            event.getPlayer().sendMessage(this.messages.getMessageComponent("freeze.you-frozen", new String[0]));
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (frozenPlayers.contains(player)) {
            if (player.isGliding() || player.getInventory().getItemInMainHand().getType() == Material.ENDER_PEARL) {
                return;
            }
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (frozenPlayers.contains(player)) {
            Material mat;
            Material material = mat = event.getItem() != null ? event.getItem().getType() : null;
            if (mat == Material.ENDER_PEARL) {
                return;
            }
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerDrop(PlayerDropItemEvent event) {
        if (frozenPlayers.contains(event.getPlayer())) {
            event.setCancelled(true);
        }
    }
}

