/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.staff;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.lunark.io.ServerEssentials;
import net.lunark.io.util.MessagesManager;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MuteCommand
implements CommandExecutor {
    private static final Map<UUID, MuteData> mutedPlayers = new HashMap<UUID, MuteData>();
    private final MessagesManager messages;
    private final File muteFile;
    private final FileConfiguration muteConfig;

    public MuteCommand(ServerEssentials plugin) {
        this.messages = new MessagesManager(plugin);
        this.messages.addDefault("mute.no-permission", "<red>You don't have permission.");
        this.messages.addDefault("mute.usage", "<yellow>Usage: /mute <player> <reason> [duration]");
        this.messages.addDefault("mute.not-found", "<red>Player not found.");
        this.messages.addDefault("mute.already-muted", "<red><player> is already muted for <reason>.");
        this.messages.addDefault("mute.success", "<yellow>You muted <green><player></green> <gray>for <reason> <yellow>(<duration>)</yellow>.");
        this.messages.addDefault("mute.notify", "<red>You have been muted! <gray>Reason: <reason> <yellow>(<duration>)</yellow>");
        this.messages.addDefault("unmute.notify", "<green>You have been unmuted!");
        this.muteFile = new File(plugin.getDataFolder(), "storage/mutes.yml");
        if (!this.muteFile.exists()) {
            try {
                this.muteFile.getParentFile().mkdirs();
                this.muteFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.muteConfig = YamlConfiguration.loadConfiguration((File)this.muteFile);
        if (this.muteConfig.contains("mutes")) {
            for (String uuidString : this.muteConfig.getConfigurationSection("mutes").getKeys(false)) {
                String reason = this.muteConfig.getString("mutes." + uuidString + ".reason", "No reason");
                long expiresAt = this.muteConfig.getLong("mutes." + uuidString + ".expiresAt", -1L);
                mutedPlayers.put(UUID.fromString(uuidString), new MuteData(reason, expiresAt));
            }
        }
        new BukkitRunnable(){

            public void run() {
                Iterator<Map.Entry<UUID, MuteData>> iterator = mutedPlayers.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<UUID, MuteData> entry = iterator.next();
                    MuteData data = entry.getValue();
                    if (data.expiresAt == -1L || System.currentTimeMillis() <= data.expiresAt) continue;
                    UUID uuid = entry.getKey();
                    iterator.remove();
                    MuteCommand.this.muteConfig.set("mutes." + String.valueOf(uuid), null);
                    MuteCommand.this.saveMutes();
                    Player player = Bukkit.getPlayer((UUID)uuid);
                    if (player == null || !player.isOnline()) continue;
                    player.sendMessage(MuteCommand.this.messages.getMessageComponent("unmute.notify", new String[0]));
                }
            }
        }.runTaskTimer((Plugin)plugin, 20L, 1200L);
    }

    public static void unmute(UUID uuid, MessagesManager messages) {
        if (!mutedPlayers.containsKey(uuid)) {
            return;
        }
        mutedPlayers.remove(uuid);
        File muteFile = new File(ServerEssentials.getInstance().getDataFolder(), "storage/mutes.yml");
        YamlConfiguration muteConfig = YamlConfiguration.loadConfiguration((File)muteFile);
        muteConfig.set("mutes." + String.valueOf(uuid), null);
        try {
            muteConfig.save(muteFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player != null && player.isOnline()) {
            player.sendMessage(messages.getMessageComponent("unmute.notify", new String[0]));
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!sender.hasPermission("serveressentials.mute")) {
            sender.sendMessage(this.messages.getMessageComponent("mute.no-permission", new String[0]));
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(this.messages.getMessageComponent("mute.usage", new String[0]));
            return true;
        }
        Player target = Bukkit.getPlayerExact((String)args[0]);
        if (target == null) {
            sender.sendMessage(this.messages.getMessageComponent("mute.not-found", new String[0]));
            return true;
        }
        String reason = args[1];
        String durationStr = args.length > 2 ? args[2] : "perm";
        long expiresAt = this.parseDuration(durationStr);
        if (mutedPlayers.containsKey(target.getUniqueId())) {
            MuteData data = mutedPlayers.get(target.getUniqueId());
            sender.sendMessage(this.messages.getMessageComponent("mute.already-muted", "<player>", target.getName(), "<reason>", data.reason));
            return true;
        }
        mutedPlayers.put(target.getUniqueId(), new MuteData(reason, expiresAt));
        this.muteConfig.set("mutes." + String.valueOf(target.getUniqueId()) + ".reason", (Object)reason);
        this.muteConfig.set("mutes." + String.valueOf(target.getUniqueId()) + ".expiresAt", (Object)expiresAt);
        this.saveMutes();
        sender.sendMessage(this.messages.getMessageComponent("mute.success", "<player>", target.getName(), "<reason>", reason, "<duration>", durationStr));
        target.sendMessage(this.messages.getMessageComponent("mute.notify", "<reason>", reason, "<duration>", durationStr));
        return true;
    }

    private void saveMutes() {
        try {
            this.muteConfig.save(this.muteFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean isMuted(UUID uuid) {
        if (!mutedPlayers.containsKey(uuid)) {
            return false;
        }
        MuteData data = mutedPlayers.get(uuid);
        if (data.expiresAt != -1L && System.currentTimeMillis() > data.expiresAt) {
            mutedPlayers.remove(uuid);
            return false;
        }
        return true;
    }

    public static String getMuteReason(UUID uuid) {
        MuteData data = mutedPlayers.get(uuid);
        return data != null ? data.reason : "No reason";
    }

    private long parseDuration(String input) {
        if (input.equalsIgnoreCase("perm")) {
            return -1L;
        }
        try {
            long time = Long.parseLong(input.substring(0, input.length() - 1));
            char unit = input.charAt(input.length() - 1);
            switch (unit) {
                case 's': {
                    return System.currentTimeMillis() + time * 1000L;
                }
                case 'm': {
                    return System.currentTimeMillis() + time * 60L * 1000L;
                }
                case 'h': {
                    return System.currentTimeMillis() + time * 60L * 60L * 1000L;
                }
                case 'd': {
                    return System.currentTimeMillis() + time * 24L * 60L * 60L * 1000L;
                }
            }
            return -1L;
        }
        catch (Exception e) {
            return -1L;
        }
    }

    private static class MuteData {
        String reason;
        long expiresAt;

        public MuteData(String reason, long expiresAt) {
            this.reason = reason;
            this.expiresAt = expiresAt;
        }
    }
}

