/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.staff;

import net.lunark.io.ServerEssentials;
import net.lunark.io.staff.MuteCommand;
import net.lunark.io.util.MessagesManager;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class UnmuteCommand
implements CommandExecutor {
    private final MessagesManager messages;

    public UnmuteCommand(ServerEssentials plugin) {
        this.messages = new MessagesManager(plugin);
        this.messages.addDefault("unmute.no-permission", "<red>You don't have permission.");
        this.messages.addDefault("unmute.usage", "<red>Usage: /unmute <player>");
        this.messages.addDefault("unmute.player-not-found", "<red>Player <#00ffff>%player%</#00ffff> not found.");
        this.messages.addDefault("unmute.unmuted", "<green>Successfully unmuted <#00ffff>%player%</#00ffff>");
        this.messages.addDefault("unmute.not-muted", "<red>That player is not muted.");
        this.messages.addDefault("unmute.notify", "<green>You have been unmuted!");
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!sender.hasPermission("serveressentials.unmute")) {
            sender.sendMessage(this.messages.getMessageComponent("unmute.no-permission", new String[0]));
            return true;
        }
        if (args.length != 1) {
            sender.sendMessage(this.messages.getMessageComponent("unmute.usage", new String[0]));
            return true;
        }
        Player target = Bukkit.getPlayerExact((String)args[0]);
        if (target == null) {
            sender.sendMessage(this.messages.getMessageComponent("unmute.player-not-found", "%player%", args[0]));
            return true;
        }
        if (MuteCommand.isMuted(target.getUniqueId())) {
            MuteCommand.unmute(target.getUniqueId(), this.messages);
            sender.sendMessage(this.messages.getMessageComponent("unmute.unmuted", "%player%", target.getName()));
        } else {
            sender.sendMessage(this.messages.getMessageComponent("unmute.not-muted", "%player%", target.getName()));
        }
        return true;
    }
}

