/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class DailyRewardsManager {
    private static JavaPlugin plugin;
    private static FileConfiguration config;
    private static File configFile;

    public DailyRewardsManager(JavaPlugin pl) {
        plugin = pl;
        DailyRewardsManager.loadConfig();
    }

    private static void loadConfig() {
        File folder = new File(plugin.getDataFolder(), "config/Daily");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if (!(configFile = new File(folder, "daily.yml")).exists()) {
            try (InputStream in = plugin.getResource("config/Daily/daily.yml");){
                if (in != null) {
                    Files.copy(in, configFile.toPath(), new CopyOption[0]);
                } else {
                    plugin.getLogger().warning("[ServerEssentials] Missing resource: config/Daily/daily.yml in jar!");
                    configFile.createNewFile();
                }
            }
            catch (IOException e) {
                plugin.getLogger().severe("Failed to copy daily.yml from resources!");
                e.printStackTrace();
            }
        }
        config = YamlConfiguration.loadConfiguration((File)configFile);
    }

    public static void reload() {
        if (plugin == null) {
            throw new IllegalStateException("DailyRewardsManager plugin reference is null!");
        }
        if (configFile == null || !configFile.exists()) {
            DailyRewardsManager.loadConfig();
        } else {
            config = YamlConfiguration.loadConfiguration((File)configFile);
        }
        plugin.getLogger().info("DailyRewardsManager reloaded.");
    }

    public FileConfiguration getConfig() {
        return config;
    }

    public List<String> getRewardDays() {
        if (config.getConfigurationSection("rewards") == null) {
            return List.of();
        }
        return new ArrayList<String>(config.getConfigurationSection("rewards").getKeys(false));
    }

    public List<Map<String, Object>> getRewardItems(String day) {
        List raw = config.getMapList("rewards." + day + ".items");
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (Map map : raw) {
            list.add(map);
        }
        return list;
    }

    public int getRewardPage(String day) {
        return config.getInt("rewards." + day + ".page", 1);
    }

    public int getRewardSlot(String day) {
        return config.getInt("rewards." + day + ".slot", 0);
    }

    public Map<String, Object> getFirstRewardItem(String day) {
        List<Map<String, Object>> items = this.getRewardItems(day);
        return items.isEmpty() ? Map.of() : items.get(0);
    }

    public int getTotalPages() {
        int pages = 1;
        for (String day : this.getRewardDays()) {
            pages = Math.max(pages, this.getRewardPage(day));
        }
        return pages;
    }
}

