/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.warp;

import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.lunark.io.ServerEssentials;
import net.lunark.io.util.WarpMessages;
import net.lunark.io.warp.WarpManager;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class WarpCommand
implements CommandExecutor {
    private final ServerEssentials plugin;
    private final WarpManager warpManager;
    private final WarpMessages messages;

    public WarpCommand(ServerEssentials plugin) {
        this.plugin = plugin;
        this.warpManager = plugin.getWarpManager();
        this.messages = plugin.getWarpMessages();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage((Component)Component.text("Only players can use this command!"));
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            player.sendMessage(this.messages.get("usage", "<command>", "/warp <name>"));
            return true;
        }
        String warpName = args[0].toLowerCase();
        switch (command.getName().toLowerCase()) {
            case "warp": {
                if (!player.hasPermission("serveressentials.warp")) {
                    player.sendMessage(this.messages.get("no-permission", new String[0]));
                    return true;
                }
                if (!this.warpManager.exists(warpName)) {
                    player.sendMessage(this.messages.get("warp-not-found", "<warp>", warpName));
                    return true;
                }
                Location loc = this.warpManager.getWarp(warpName);
                player.teleport(loc);
                player.sendMessage(this.messages.get("warp-success", "<warp>", warpName));
                break;
            }
            case "setwarp": {
                if (!player.hasPermission("serveressentials.setwarp")) {
                    player.sendMessage(this.messages.get("no-permission", new String[0]));
                    return true;
                }
                int maxWarps = Integer.MAX_VALUE;
                for (int i = 1; i <= 100; ++i) {
                    if (!player.hasPermission("serveressentials.set.warp" + i)) continue;
                    maxWarps = i;
                }
                long playerWarps = this.warpManager.getWarps().entrySet().stream().filter(e -> player.getUniqueId().equals(this.warpManager.getCreator((String)e.getKey()))).count();
                if (playerWarps >= (long)maxWarps) {
                    player.sendMessage(this.messages.get("warp-limit-reached", "<limit>", String.valueOf(maxWarps)));
                    return true;
                }
                this.warpManager.addWarp(warpName, player.getLocation(), player.getUniqueId());
                player.sendMessage(this.messages.get("warp-set", "<warp>", warpName));
                break;
            }
            case "delwarp": {
                if (!player.hasPermission("serveressentials.delwarp")) {
                    player.sendMessage(this.messages.get("no-permission", new String[0]));
                    return true;
                }
                if (!this.warpManager.exists(warpName)) {
                    player.sendMessage(this.messages.get("warp-not-found", "<warp>", warpName));
                    return true;
                }
                UUID creator = this.warpManager.getCreator(warpName);
                if (!player.getUniqueId().equals(creator) && !player.hasPermission("serveressentials.delwarp.all")) {
                    player.sendMessage(this.messages.get("warp-no-permission-delete", new String[0]));
                    return true;
                }
                this.warpManager.removeWarp(warpName);
                player.sendMessage(this.messages.get("warp-removed", "<warp>", warpName));
            }
        }
        return true;
    }
}

