/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.auto.value.AutoValue;
import com.google.cloud.firestore.AutoValue_FieldPath;
import com.google.cloud.firestore.BasePath;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.firestore.v1.StructuredQuery;
import java.util.regex.Pattern;

@AutoValue
public abstract class FieldPath
extends BasePath<FieldPath>
implements Comparable<FieldPath> {
    private static final String DOCUMENT_ID_SENTINEL = "__name__";
    static final FieldPath DOCUMENT_ID = FieldPath.of("__name__");
    private static final Pattern PROHIBITED_CHARACTERS = Pattern.compile(".*[~*/\\[\\]].*");
    private String encodedPath;

    public static FieldPath of(String ... fieldNames) {
        Preconditions.checkArgument(fieldNames.length > 0, "Invalid field path. Provided path must not be empty.");
        for (int i = 0; i < fieldNames.length; ++i) {
            Preconditions.checkArgument(fieldNames[i] != null && !fieldNames[i].isEmpty(), "Invalid field name at argument " + (i + 1) + ". Field names must not be null or empty.");
        }
        return new AutoValue_FieldPath(ImmutableList.copyOf(fieldNames));
    }

    public static FieldPath documentId() {
        return DOCUMENT_ID;
    }

    static boolean isDocumentId(String path) {
        return DOCUMENT_ID_SENTINEL.equals(path);
    }

    static FieldPath fromDotSeparatedString(String field) {
        if (PROHIBITED_CHARACTERS.matcher(field).matches()) {
            throw new IllegalArgumentException("Use FieldPath.of() for field names containing '\u02dc*/[]'.");
        }
        return (FieldPath)FieldPath.empty().append(field);
    }

    static FieldPath empty() {
        return new AutoValue_FieldPath(ImmutableList.of());
    }

    String getEncodedPath() {
        if (this.encodedPath == null) {
            this.encodedPath = this.canonicalString();
        }
        return this.encodedPath;
    }

    @Override
    String[] splitChildPath(String path) {
        return path.split("\\.", -1);
    }

    private static boolean isValidIdentifier(String identifier) {
        if (identifier.isEmpty()) {
            return false;
        }
        char first = identifier.charAt(0);
        if (!(first == '_' || first >= 'a' && first <= 'z' || first >= 'A' && first <= 'Z')) {
            return false;
        }
        for (int i = 1; i < identifier.length(); ++i) {
            char c = identifier.charAt(i);
            if (c == '_' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    private String canonicalString() {
        ImmutableList<String> segments = this.getSegments();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < segments.size(); ++i) {
            if (i > 0) {
                builder.append(".");
            }
            String escaped = (String)segments.get(i);
            if (!FieldPath.isValidIdentifier(escaped = escaped.replace("\\", "\\\\").replace("`", "\\`"))) {
                escaped = '`' + escaped + '`';
            }
            builder.append(escaped);
        }
        return builder.toString();
    }

    @Override
    FieldPath createPathWithSegments(ImmutableList<String> segments) {
        return new AutoValue_FieldPath(segments);
    }

    public String toString() {
        return this.getEncodedPath();
    }

    StructuredQuery.FieldReference toProto() {
        return StructuredQuery.FieldReference.newBuilder().setFieldPath(this.getEncodedPath()).build();
    }
}

