/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.ServerStreamingCallSettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StreamingCallSettings;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.firestore.v1.FirestoreClient;
import com.google.cloud.firestore.v1.stub.FirestoreStub;
import com.google.cloud.firestore.v1.stub.GrpcFirestoreStub;
import com.google.cloud.firestore.v1.stub.HttpJsonFirestoreStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.firestore.v1.BatchGetDocumentsRequest;
import com.google.firestore.v1.BatchGetDocumentsResponse;
import com.google.firestore.v1.BatchWriteRequest;
import com.google.firestore.v1.BatchWriteResponse;
import com.google.firestore.v1.BeginTransactionRequest;
import com.google.firestore.v1.BeginTransactionResponse;
import com.google.firestore.v1.CommitRequest;
import com.google.firestore.v1.CommitResponse;
import com.google.firestore.v1.CreateDocumentRequest;
import com.google.firestore.v1.Cursor;
import com.google.firestore.v1.DeleteDocumentRequest;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.GetDocumentRequest;
import com.google.firestore.v1.ListCollectionIdsRequest;
import com.google.firestore.v1.ListCollectionIdsResponse;
import com.google.firestore.v1.ListDocumentsRequest;
import com.google.firestore.v1.ListDocumentsResponse;
import com.google.firestore.v1.ListenRequest;
import com.google.firestore.v1.ListenResponse;
import com.google.firestore.v1.PartitionQueryRequest;
import com.google.firestore.v1.PartitionQueryResponse;
import com.google.firestore.v1.RollbackRequest;
import com.google.firestore.v1.RunAggregationQueryRequest;
import com.google.firestore.v1.RunAggregationQueryResponse;
import com.google.firestore.v1.RunQueryRequest;
import com.google.firestore.v1.RunQueryResponse;
import com.google.firestore.v1.UpdateDocumentRequest;
import com.google.firestore.v1.WriteRequest;
import com.google.firestore.v1.WriteResponse;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class FirestoreStubSettings
extends StubSettings<FirestoreStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add("https://www.googleapis.com/auth/cloud-platform")).add("https://www.googleapis.com/auth/datastore")).build();
    private final UnaryCallSettings<GetDocumentRequest, Document> getDocumentSettings;
    private final PagedCallSettings<ListDocumentsRequest, ListDocumentsResponse, FirestoreClient.ListDocumentsPagedResponse> listDocumentsSettings;
    private final UnaryCallSettings<UpdateDocumentRequest, Document> updateDocumentSettings;
    private final UnaryCallSettings<DeleteDocumentRequest, Empty> deleteDocumentSettings;
    private final ServerStreamingCallSettings<BatchGetDocumentsRequest, BatchGetDocumentsResponse> batchGetDocumentsSettings;
    private final UnaryCallSettings<BeginTransactionRequest, BeginTransactionResponse> beginTransactionSettings;
    private final UnaryCallSettings<CommitRequest, CommitResponse> commitSettings;
    private final UnaryCallSettings<RollbackRequest, Empty> rollbackSettings;
    private final ServerStreamingCallSettings<RunQueryRequest, RunQueryResponse> runQuerySettings;
    private final ServerStreamingCallSettings<RunAggregationQueryRequest, RunAggregationQueryResponse> runAggregationQuerySettings;
    private final PagedCallSettings<PartitionQueryRequest, PartitionQueryResponse, FirestoreClient.PartitionQueryPagedResponse> partitionQuerySettings;
    private final StreamingCallSettings<WriteRequest, WriteResponse> writeSettings;
    private final StreamingCallSettings<ListenRequest, ListenResponse> listenSettings;
    private final PagedCallSettings<ListCollectionIdsRequest, ListCollectionIdsResponse, FirestoreClient.ListCollectionIdsPagedResponse> listCollectionIdsSettings;
    private final UnaryCallSettings<BatchWriteRequest, BatchWriteResponse> batchWriteSettings;
    private final UnaryCallSettings<CreateDocumentRequest, Document> createDocumentSettings;
    private static final PagedListDescriptor<ListDocumentsRequest, ListDocumentsResponse, Document> LIST_DOCUMENTS_PAGE_STR_DESC = new PagedListDescriptor<ListDocumentsRequest, ListDocumentsResponse, Document>(){

        @Override
        public String emptyToken() {
            return "";
        }

        @Override
        public ListDocumentsRequest injectToken(ListDocumentsRequest payload, String token) {
            return ListDocumentsRequest.newBuilder(payload).setPageToken(token).build();
        }

        @Override
        public ListDocumentsRequest injectPageSize(ListDocumentsRequest payload, int pageSize) {
            return ListDocumentsRequest.newBuilder(payload).setPageSize(pageSize).build();
        }

        @Override
        public Integer extractPageSize(ListDocumentsRequest payload) {
            return payload.getPageSize();
        }

        @Override
        public String extractNextToken(ListDocumentsResponse payload) {
            return payload.getNextPageToken();
        }

        @Override
        public Iterable<Document> extractResources(ListDocumentsResponse payload) {
            return payload.getDocumentsList() == null ? ImmutableList.of() : payload.getDocumentsList();
        }
    };
    private static final PagedListDescriptor<PartitionQueryRequest, PartitionQueryResponse, Cursor> PARTITION_QUERY_PAGE_STR_DESC = new PagedListDescriptor<PartitionQueryRequest, PartitionQueryResponse, Cursor>(){

        @Override
        public String emptyToken() {
            return "";
        }

        @Override
        public PartitionQueryRequest injectToken(PartitionQueryRequest payload, String token) {
            return PartitionQueryRequest.newBuilder(payload).setPageToken(token).build();
        }

        @Override
        public PartitionQueryRequest injectPageSize(PartitionQueryRequest payload, int pageSize) {
            return PartitionQueryRequest.newBuilder(payload).setPageSize(pageSize).build();
        }

        @Override
        public Integer extractPageSize(PartitionQueryRequest payload) {
            return payload.getPageSize();
        }

        @Override
        public String extractNextToken(PartitionQueryResponse payload) {
            return payload.getNextPageToken();
        }

        @Override
        public Iterable<Cursor> extractResources(PartitionQueryResponse payload) {
            return payload.getPartitionsList() == null ? ImmutableList.of() : payload.getPartitionsList();
        }
    };
    private static final PagedListDescriptor<ListCollectionIdsRequest, ListCollectionIdsResponse, String> LIST_COLLECTION_IDS_PAGE_STR_DESC = new PagedListDescriptor<ListCollectionIdsRequest, ListCollectionIdsResponse, String>(){

        @Override
        public String emptyToken() {
            return "";
        }

        @Override
        public ListCollectionIdsRequest injectToken(ListCollectionIdsRequest payload, String token) {
            return ListCollectionIdsRequest.newBuilder(payload).setPageToken(token).build();
        }

        @Override
        public ListCollectionIdsRequest injectPageSize(ListCollectionIdsRequest payload, int pageSize) {
            return ListCollectionIdsRequest.newBuilder(payload).setPageSize(pageSize).build();
        }

        @Override
        public Integer extractPageSize(ListCollectionIdsRequest payload) {
            return payload.getPageSize();
        }

        @Override
        public String extractNextToken(ListCollectionIdsResponse payload) {
            return payload.getNextPageToken();
        }

        @Override
        public Iterable<String> extractResources(ListCollectionIdsResponse payload) {
            return payload.getCollectionIdsList() == null ? ImmutableList.of() : payload.getCollectionIdsList();
        }
    };
    private static final PagedListResponseFactory<ListDocumentsRequest, ListDocumentsResponse, FirestoreClient.ListDocumentsPagedResponse> LIST_DOCUMENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListDocumentsRequest, ListDocumentsResponse, FirestoreClient.ListDocumentsPagedResponse>(){

        @Override
        public ApiFuture<FirestoreClient.ListDocumentsPagedResponse> getFuturePagedResponse(UnaryCallable<ListDocumentsRequest, ListDocumentsResponse> callable, ListDocumentsRequest request, ApiCallContext context, ApiFuture<ListDocumentsResponse> futureResponse) {
            PageContext<ListDocumentsRequest, ListDocumentsResponse, Document> pageContext = PageContext.create(callable, LIST_DOCUMENTS_PAGE_STR_DESC, request, context);
            return FirestoreClient.ListDocumentsPagedResponse.createAsync(pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<PartitionQueryRequest, PartitionQueryResponse, FirestoreClient.PartitionQueryPagedResponse> PARTITION_QUERY_PAGE_STR_FACT = new PagedListResponseFactory<PartitionQueryRequest, PartitionQueryResponse, FirestoreClient.PartitionQueryPagedResponse>(){

        @Override
        public ApiFuture<FirestoreClient.PartitionQueryPagedResponse> getFuturePagedResponse(UnaryCallable<PartitionQueryRequest, PartitionQueryResponse> callable, PartitionQueryRequest request, ApiCallContext context, ApiFuture<PartitionQueryResponse> futureResponse) {
            PageContext<PartitionQueryRequest, PartitionQueryResponse, Cursor> pageContext = PageContext.create(callable, PARTITION_QUERY_PAGE_STR_DESC, request, context);
            return FirestoreClient.PartitionQueryPagedResponse.createAsync(pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListCollectionIdsRequest, ListCollectionIdsResponse, FirestoreClient.ListCollectionIdsPagedResponse> LIST_COLLECTION_IDS_PAGE_STR_FACT = new PagedListResponseFactory<ListCollectionIdsRequest, ListCollectionIdsResponse, FirestoreClient.ListCollectionIdsPagedResponse>(){

        @Override
        public ApiFuture<FirestoreClient.ListCollectionIdsPagedResponse> getFuturePagedResponse(UnaryCallable<ListCollectionIdsRequest, ListCollectionIdsResponse> callable, ListCollectionIdsRequest request, ApiCallContext context, ApiFuture<ListCollectionIdsResponse> futureResponse) {
            PageContext<ListCollectionIdsRequest, ListCollectionIdsResponse, String> pageContext = PageContext.create(callable, LIST_COLLECTION_IDS_PAGE_STR_DESC, request, context);
            return FirestoreClient.ListCollectionIdsPagedResponse.createAsync(pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetDocumentRequest, Document> getDocumentSettings() {
        return this.getDocumentSettings;
    }

    public PagedCallSettings<ListDocumentsRequest, ListDocumentsResponse, FirestoreClient.ListDocumentsPagedResponse> listDocumentsSettings() {
        return this.listDocumentsSettings;
    }

    public UnaryCallSettings<UpdateDocumentRequest, Document> updateDocumentSettings() {
        return this.updateDocumentSettings;
    }

    public UnaryCallSettings<DeleteDocumentRequest, Empty> deleteDocumentSettings() {
        return this.deleteDocumentSettings;
    }

    public ServerStreamingCallSettings<BatchGetDocumentsRequest, BatchGetDocumentsResponse> batchGetDocumentsSettings() {
        return this.batchGetDocumentsSettings;
    }

    public UnaryCallSettings<BeginTransactionRequest, BeginTransactionResponse> beginTransactionSettings() {
        return this.beginTransactionSettings;
    }

    public UnaryCallSettings<CommitRequest, CommitResponse> commitSettings() {
        return this.commitSettings;
    }

    public UnaryCallSettings<RollbackRequest, Empty> rollbackSettings() {
        return this.rollbackSettings;
    }

    public ServerStreamingCallSettings<RunQueryRequest, RunQueryResponse> runQuerySettings() {
        return this.runQuerySettings;
    }

    public ServerStreamingCallSettings<RunAggregationQueryRequest, RunAggregationQueryResponse> runAggregationQuerySettings() {
        return this.runAggregationQuerySettings;
    }

    public PagedCallSettings<PartitionQueryRequest, PartitionQueryResponse, FirestoreClient.PartitionQueryPagedResponse> partitionQuerySettings() {
        return this.partitionQuerySettings;
    }

    public StreamingCallSettings<WriteRequest, WriteResponse> writeSettings() {
        return this.writeSettings;
    }

    public StreamingCallSettings<ListenRequest, ListenResponse> listenSettings() {
        return this.listenSettings;
    }

    public PagedCallSettings<ListCollectionIdsRequest, ListCollectionIdsResponse, FirestoreClient.ListCollectionIdsPagedResponse> listCollectionIdsSettings() {
        return this.listCollectionIdsSettings;
    }

    public UnaryCallSettings<BatchWriteRequest, BatchWriteResponse> batchWriteSettings() {
        return this.batchWriteSettings;
    }

    public UnaryCallSettings<CreateDocumentRequest, Document> createDocumentSettings() {
        return this.createDocumentSettings;
    }

    public FirestoreStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcFirestoreStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonFirestoreStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "firestore.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "firestore.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.MAX_VALUE);
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return FirestoreStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(FirestoreStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(FirestoreStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return FirestoreStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    protected FirestoreStubSettings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder);
        this.getDocumentSettings = settingsBuilder.getDocumentSettings().build();
        this.listDocumentsSettings = settingsBuilder.listDocumentsSettings().build();
        this.updateDocumentSettings = settingsBuilder.updateDocumentSettings().build();
        this.deleteDocumentSettings = settingsBuilder.deleteDocumentSettings().build();
        this.batchGetDocumentsSettings = settingsBuilder.batchGetDocumentsSettings().build();
        this.beginTransactionSettings = settingsBuilder.beginTransactionSettings().build();
        this.commitSettings = settingsBuilder.commitSettings().build();
        this.rollbackSettings = settingsBuilder.rollbackSettings().build();
        this.runQuerySettings = settingsBuilder.runQuerySettings().build();
        this.runAggregationQuerySettings = settingsBuilder.runAggregationQuerySettings().build();
        this.partitionQuerySettings = settingsBuilder.partitionQuerySettings().build();
        this.writeSettings = settingsBuilder.writeSettings().build();
        this.listenSettings = settingsBuilder.listenSettings().build();
        this.listCollectionIdsSettings = settingsBuilder.listCollectionIdsSettings().build();
        this.batchWriteSettings = settingsBuilder.batchWriteSettings().build();
        this.createDocumentSettings = settingsBuilder.createDocumentSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<FirestoreStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetDocumentRequest, Document> getDocumentSettings;
        private final PagedCallSettings.Builder<ListDocumentsRequest, ListDocumentsResponse, FirestoreClient.ListDocumentsPagedResponse> listDocumentsSettings;
        private final UnaryCallSettings.Builder<UpdateDocumentRequest, Document> updateDocumentSettings;
        private final UnaryCallSettings.Builder<DeleteDocumentRequest, Empty> deleteDocumentSettings;
        private final ServerStreamingCallSettings.Builder<BatchGetDocumentsRequest, BatchGetDocumentsResponse> batchGetDocumentsSettings;
        private final UnaryCallSettings.Builder<BeginTransactionRequest, BeginTransactionResponse> beginTransactionSettings;
        private final UnaryCallSettings.Builder<CommitRequest, CommitResponse> commitSettings;
        private final UnaryCallSettings.Builder<RollbackRequest, Empty> rollbackSettings;
        private final ServerStreamingCallSettings.Builder<RunQueryRequest, RunQueryResponse> runQuerySettings;
        private final ServerStreamingCallSettings.Builder<RunAggregationQueryRequest, RunAggregationQueryResponse> runAggregationQuerySettings;
        private final PagedCallSettings.Builder<PartitionQueryRequest, PartitionQueryResponse, FirestoreClient.PartitionQueryPagedResponse> partitionQuerySettings;
        private final StreamingCallSettings.Builder<WriteRequest, WriteResponse> writeSettings;
        private final StreamingCallSettings.Builder<ListenRequest, ListenResponse> listenSettings;
        private final PagedCallSettings.Builder<ListCollectionIdsRequest, ListCollectionIdsResponse, FirestoreClient.ListCollectionIdsPagedResponse> listCollectionIdsSettings;
        private final UnaryCallSettings.Builder<BatchWriteRequest, BatchWriteResponse> batchWriteSettings;
        private final UnaryCallSettings.Builder<CreateDocumentRequest, Document> createDocumentSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getDocumentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listDocumentsSettings = PagedCallSettings.newBuilder(LIST_DOCUMENTS_PAGE_STR_FACT);
            this.updateDocumentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteDocumentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchGetDocumentsSettings = ServerStreamingCallSettings.newBuilder();
            this.beginTransactionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.commitSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.rollbackSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.runQuerySettings = ServerStreamingCallSettings.newBuilder();
            this.runAggregationQuerySettings = ServerStreamingCallSettings.newBuilder();
            this.partitionQuerySettings = PagedCallSettings.newBuilder(PARTITION_QUERY_PAGE_STR_FACT);
            this.writeSettings = StreamingCallSettings.newBuilder();
            this.listenSettings = StreamingCallSettings.newBuilder();
            this.listCollectionIdsSettings = PagedCallSettings.newBuilder(LIST_COLLECTION_IDS_PAGE_STR_FACT);
            this.batchWriteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createDocumentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getDocumentSettings, this.listDocumentsSettings, this.updateDocumentSettings, this.deleteDocumentSettings, this.beginTransactionSettings, this.commitSettings, this.rollbackSettings, this.partitionQuerySettings, this.listCollectionIdsSettings, this.batchWriteSettings, this.createDocumentSettings);
            Builder.initDefaults(this);
        }

        protected Builder(FirestoreStubSettings settings) {
            super(settings);
            this.getDocumentSettings = settings.getDocumentSettings.toBuilder();
            this.listDocumentsSettings = settings.listDocumentsSettings.toBuilder();
            this.updateDocumentSettings = settings.updateDocumentSettings.toBuilder();
            this.deleteDocumentSettings = settings.deleteDocumentSettings.toBuilder();
            this.batchGetDocumentsSettings = settings.batchGetDocumentsSettings.toBuilder();
            this.beginTransactionSettings = settings.beginTransactionSettings.toBuilder();
            this.commitSettings = settings.commitSettings.toBuilder();
            this.rollbackSettings = settings.rollbackSettings.toBuilder();
            this.runQuerySettings = settings.runQuerySettings.toBuilder();
            this.runAggregationQuerySettings = settings.runAggregationQuerySettings.toBuilder();
            this.partitionQuerySettings = settings.partitionQuerySettings.toBuilder();
            this.writeSettings = settings.writeSettings.toBuilder();
            this.listenSettings = settings.listenSettings.toBuilder();
            this.listCollectionIdsSettings = settings.listCollectionIdsSettings.toBuilder();
            this.batchWriteSettings = settings.batchWriteSettings.toBuilder();
            this.createDocumentSettings = settings.createDocumentSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getDocumentSettings, this.listDocumentsSettings, this.updateDocumentSettings, this.deleteDocumentSettings, this.beginTransactionSettings, this.commitSettings, this.rollbackSettings, this.partitionQuerySettings, this.listCollectionIdsSettings, this.batchWriteSettings, this.createDocumentSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(FirestoreStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider(FirestoreStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider(FirestoreStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(FirestoreStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(FirestoreStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(FirestoreStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider(FirestoreStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider(FirestoreStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(FirestoreStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(FirestoreStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getDocumentSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_4_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_4_params"));
            ((PagedCallSettings.Builder)builder.listDocumentsSettings().setRetryableCodes(RETRYABLE_CODE_DEFINITIONS.get("retry_policy_4_codes"))).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_4_params"));
            builder.updateDocumentSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_0_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_0_params"));
            builder.deleteDocumentSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_4_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_4_params"));
            builder.batchGetDocumentsSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_1_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_1_params"));
            builder.beginTransactionSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_4_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_4_params"));
            builder.commitSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_0_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_0_params"));
            builder.rollbackSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_4_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_4_params"));
            builder.runQuerySettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_1_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_1_params"));
            builder.runAggregationQuerySettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_1_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_1_params"));
            ((PagedCallSettings.Builder)builder.partitionQuerySettings().setRetryableCodes(RETRYABLE_CODE_DEFINITIONS.get("retry_policy_1_codes"))).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_1_params"));
            ((PagedCallSettings.Builder)builder.listCollectionIdsSettings().setRetryableCodes(RETRYABLE_CODE_DEFINITIONS.get("retry_policy_4_codes"))).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_4_params"));
            builder.batchWriteSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_5_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_5_params"));
            builder.createDocumentSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("retry_policy_0_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetDocumentRequest, Document> getDocumentSettings() {
            return this.getDocumentSettings;
        }

        public PagedCallSettings.Builder<ListDocumentsRequest, ListDocumentsResponse, FirestoreClient.ListDocumentsPagedResponse> listDocumentsSettings() {
            return this.listDocumentsSettings;
        }

        public UnaryCallSettings.Builder<UpdateDocumentRequest, Document> updateDocumentSettings() {
            return this.updateDocumentSettings;
        }

        public UnaryCallSettings.Builder<DeleteDocumentRequest, Empty> deleteDocumentSettings() {
            return this.deleteDocumentSettings;
        }

        public ServerStreamingCallSettings.Builder<BatchGetDocumentsRequest, BatchGetDocumentsResponse> batchGetDocumentsSettings() {
            return this.batchGetDocumentsSettings;
        }

        public UnaryCallSettings.Builder<BeginTransactionRequest, BeginTransactionResponse> beginTransactionSettings() {
            return this.beginTransactionSettings;
        }

        public UnaryCallSettings.Builder<CommitRequest, CommitResponse> commitSettings() {
            return this.commitSettings;
        }

        public UnaryCallSettings.Builder<RollbackRequest, Empty> rollbackSettings() {
            return this.rollbackSettings;
        }

        public ServerStreamingCallSettings.Builder<RunQueryRequest, RunQueryResponse> runQuerySettings() {
            return this.runQuerySettings;
        }

        public ServerStreamingCallSettings.Builder<RunAggregationQueryRequest, RunAggregationQueryResponse> runAggregationQuerySettings() {
            return this.runAggregationQuerySettings;
        }

        public PagedCallSettings.Builder<PartitionQueryRequest, PartitionQueryResponse, FirestoreClient.PartitionQueryPagedResponse> partitionQuerySettings() {
            return this.partitionQuerySettings;
        }

        public StreamingCallSettings.Builder<WriteRequest, WriteResponse> writeSettings() {
            return this.writeSettings;
        }

        public StreamingCallSettings.Builder<ListenRequest, ListenResponse> listenSettings() {
            return this.listenSettings;
        }

        public PagedCallSettings.Builder<ListCollectionIdsRequest, ListCollectionIdsResponse, FirestoreClient.ListCollectionIdsPagedResponse> listCollectionIdsSettings() {
            return this.listCollectionIdsSettings;
        }

        public UnaryCallSettings.Builder<BatchWriteRequest, BatchWriteResponse> batchWriteSettings() {
            return this.batchWriteSettings;
        }

        public UnaryCallSettings.Builder<CreateDocumentRequest, Document> createDocumentSettings() {
            return this.createDocumentSettings;
        }

        public FirestoreStubSettings build() throws IOException {
            return new FirestoreStubSettings(this);
        }

        static {
            ImmutableMap.Builder<String, Serializable> definitions = ImmutableMap.builder();
            definitions.put("retry_policy_4_codes", ImmutableSet.copyOf(Lists.newArrayList(StatusCode.Code.RESOURCE_EXHAUSTED, StatusCode.Code.UNAVAILABLE, StatusCode.Code.INTERNAL, StatusCode.Code.DEADLINE_EXCEEDED)));
            definitions.put("retry_policy_0_codes", ImmutableSet.copyOf(Lists.newArrayList(StatusCode.Code.RESOURCE_EXHAUSTED, StatusCode.Code.UNAVAILABLE)));
            definitions.put("retry_policy_1_codes", ImmutableSet.copyOf(Lists.newArrayList(StatusCode.Code.RESOURCE_EXHAUSTED, StatusCode.Code.UNAVAILABLE, StatusCode.Code.INTERNAL, StatusCode.Code.DEADLINE_EXCEEDED)));
            definitions.put("no_retry_3_codes", ImmutableSet.copyOf(Lists.newArrayList()));
            definitions.put("retry_policy_2_codes", ImmutableSet.copyOf(Lists.newArrayList(StatusCode.Code.RESOURCE_EXHAUSTED, StatusCode.Code.UNAVAILABLE, StatusCode.Code.INTERNAL, StatusCode.Code.DEADLINE_EXCEEDED)));
            definitions.put("retry_policy_5_codes", ImmutableSet.copyOf(Lists.newArrayList(StatusCode.Code.RESOURCE_EXHAUSTED, StatusCode.Code.UNAVAILABLE, StatusCode.Code.ABORTED)));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis(100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis(60000L)).setInitialRpcTimeout(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis(60000L)).setTotalTimeout(Duration.ofMillis(60000L)).build();
            definitions.put("retry_policy_4_params", settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis(100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis(60000L)).setInitialRpcTimeout(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis(60000L)).setTotalTimeout(Duration.ofMillis(60000L)).build();
            definitions.put("retry_policy_0_params", settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis(100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis(60000L)).setInitialRpcTimeout(Duration.ofMillis(300000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis(300000L)).setTotalTimeout(Duration.ofMillis(300000L)).build();
            definitions.put("retry_policy_1_params", settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis(86400000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis(86400000L)).setTotalTimeout(Duration.ofMillis(86400000L)).build();
            definitions.put("no_retry_3_params", settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis(100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis(60000L)).setInitialRpcTimeout(Duration.ofMillis(86400000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis(86400000L)).setTotalTimeout(Duration.ofMillis(86400000L)).build();
            definitions.put("retry_policy_2_params", settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis(100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis(60000L)).setInitialRpcTimeout(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis(60000L)).setTotalTimeout(Duration.ofMillis(60000L)).build();
            definitions.put("retry_policy_5_params", settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

