/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiClock;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GrpcInterceptorProvider;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.StreamResumptionStrategy;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.NoHeaderProvider;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.internal.QuotaProjectIdHidingCredentials;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.ServiceFactory;
import com.google.cloud.ServiceOptions;
import com.google.cloud.ServiceRpc;
import com.google.cloud.TransportOptions;
import com.google.cloud.Tuple;
import com.google.cloud.grpc.GrpcTransportOptions;
import com.google.cloud.spi.ServiceRpcFactory;
import com.google.cloud.storage.GrpcRetryAlgorithmManager;
import com.google.cloud.storage.GrpcStorageImpl;
import com.google.cloud.storage.Retrying;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageFactory;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.StorageRetryStrategy;
import com.google.cloud.storage.TransportCompatibility;
import com.google.cloud.storage.UnifiedOpts;
import com.google.cloud.storage.spi.StorageRpcFactory;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.storage.v2.ReadObjectRequest;
import com.google.storage.v2.ReadObjectResponse;
import com.google.storage.v2.StorageClient;
import com.google.storage.v2.StorageSettings;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannelBuilder;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.threeten.bp.Duration;

@BetaApi
@TransportCompatibility(value={TransportCompatibility.Transport.GRPC})
public final class GrpcStorageOptions
extends StorageOptions
implements Retrying.RetryingDependencies {
    private static final long serialVersionUID = -4499446543857945349L;
    private static final String GCS_SCOPE = "https://www.googleapis.com/auth/devstorage.full_control";
    private static final Set<String> SCOPES = ImmutableSet.of("https://www.googleapis.com/auth/devstorage.full_control");
    private static final String DEFAULT_HOST = "https://storage.googleapis.com";
    private final GrpcRetryAlgorithmManager retryAlgorithmManager;
    private final Duration terminationAwaitDuration;
    private final boolean attemptDirectPath;
    private final GrpcInterceptorProvider grpcInterceptorProvider;

    private GrpcStorageOptions(Builder builder, GrpcStorageDefaults serviceDefaults) {
        super(builder, serviceDefaults);
        this.retryAlgorithmManager = new GrpcRetryAlgorithmManager(MoreObjects.firstNonNull(builder.storageRetryStrategy, serviceDefaults.getStorageRetryStrategy()));
        this.terminationAwaitDuration = MoreObjects.firstNonNull(builder.terminationAwaitDuration, serviceDefaults.getTerminationAwaitDuration());
        this.attemptDirectPath = builder.attemptDirectPath;
        this.grpcInterceptorProvider = builder.grpcInterceptorProvider;
    }

    @Override
    protected Set<String> getScopes() {
        return SCOPES;
    }

    @InternalApi
    GrpcRetryAlgorithmManager getRetryAlgorithmManager() {
        return this.retryAlgorithmManager;
    }

    @InternalApi
    Duration getTerminationAwaitDuration() {
        return this.terminationAwaitDuration;
    }

    @InternalApi
    StorageSettings getStorageSettings() throws IOException {
        return this.resolveSettingsAndOpts().x();
    }

    private Tuple<StorageSettings, UnifiedOpts.Opts<UnifiedOpts.UserProject>> resolveSettingsAndOpts() throws IOException {
        CredentialsProvider credentialsProvider;
        String endpoint = this.getHost();
        URI uri = URI.create(endpoint);
        String scheme = uri.getScheme();
        int port = uri.getPort();
        switch (scheme) {
            case "http": {
                endpoint = String.format("%s:%s", uri.getHost(), port > 0 ? port : 80);
                break;
            }
            case "https": {
                endpoint = String.format("%s:%s", uri.getHost(), port > 0 ? port : 443);
            }
        }
        UnifiedOpts.Opts<Object> defaultOpts = UnifiedOpts.Opts.empty();
        if (this.credentials instanceof NoCredentials) {
            credentialsProvider = NoCredentialsProvider.create();
        } else {
            boolean foundQuotaProject;
            block18: {
                foundQuotaProject = false;
                if (this.credentials.hasRequestMetadata()) {
                    try {
                        Map<String, List<String>> requestMetadata = this.credentials.getRequestMetadata(uri);
                        for (Map.Entry<String, List<String>> e : requestMetadata.entrySet()) {
                            List<String> value;
                            String key = e.getKey();
                            if (!"x-goog-user-project".equals(key.trim().toLowerCase(Locale.ENGLISH)) || (value = e.getValue()).isEmpty()) continue;
                            foundQuotaProject = true;
                            defaultOpts = UnifiedOpts.Opts.from(UnifiedOpts.userProject(value.get(0)));
                            break;
                        }
                    }
                    catch (IllegalStateException e) {
                        if (e.getMessage().startsWith("OAuth2Credentials")) break block18;
                        throw e;
                    }
                }
            }
            credentialsProvider = foundQuotaProject ? FixedCredentialsProvider.create(new QuotaProjectIdHidingCredentials(this.credentials)) : FixedCredentialsProvider.create(this.credentials);
        }
        ApiClientHeaderProvider internalHeaderProvider = StorageSettings.defaultApiClientHeaderProviderBuilder().setClientLibToken(ServiceOptions.getGoogApiClientLibName(), GaxProperties.getLibraryVersion(this.getClass())).build();
        StorageSettings.Builder builder = (StorageSettings.Builder)((StorageSettings.Builder)((StorageSettings.Builder)new StorageSettingsBuilder(StorageSettings.newBuilder().build()).setInternalHeaderProvider(internalHeaderProvider).setEndpoint(endpoint)).setCredentialsProvider(credentialsProvider)).setClock(this.getClock());
        String quotaProjectId = this.getQuotaProjectId();
        if (quotaProjectId != null && !quotaProjectId.isEmpty()) {
            defaultOpts = UnifiedOpts.Opts.from(UnifiedOpts.userProject(quotaProjectId));
        }
        builder.setHeaderProvider(this.getMergedHeaderProvider(new NoHeaderProvider()));
        InstantiatingGrpcChannelProvider.Builder channelProviderBuilder = InstantiatingGrpcChannelProvider.newBuilder().setEndpoint(endpoint).setAllowNonDefaultServiceAccount(true).setAttemptDirectPath(this.attemptDirectPath);
        if (!NoopGrpcInterceptorProvider.INSTANCE.equals(this.grpcInterceptorProvider)) {
            channelProviderBuilder.setInterceptorProvider(this.grpcInterceptorProvider);
        }
        if (this.attemptDirectPath) {
            channelProviderBuilder.setAttemptDirectPathXds();
        }
        if (scheme.equals("http")) {
            channelProviderBuilder.setChannelConfigurator(ManagedChannelBuilder::usePlaintext);
        }
        builder.setTransportChannelProvider(channelProviderBuilder.build());
        RetrySettings baseRetrySettings = this.getRetrySettings();
        RetrySettings readRetrySettings = baseRetrySettings.toBuilder().setLogicalTimeout(Duration.ofDays(28L)).build();
        Duration totalTimeout = baseRetrySettings.getTotalTimeout();
        Set<StatusCode.Code> startResumableWriteRetryableCodes = builder.startResumableWriteSettings().getRetryableCodes();
        builder.applyToAllUnaryMethods(input -> {
            input.setSimpleTimeoutNoRetries(totalTimeout);
            return null;
        });
        builder.startResumableWriteSettings().setRetrySettings(baseRetrySettings).setRetryableCodes(startResumableWriteRetryableCodes);
        builder.readObjectSettings().setRetrySettings(readRetrySettings).setResumptionStrategy(new ReadObjectResumptionStrategy()).setIdleTimeout(totalTimeout);
        return Tuple.of(builder.build(), defaultOpts);
    }

    @Override
    @BetaApi
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public int hashCode() {
        return this.baseHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof GrpcStorageOptions && this.baseEquals((GrpcStorageOptions)obj);
    }

    @BetaApi
    public static Builder newBuilder() {
        return new Builder().setHost(DEFAULT_HOST);
    }

    @BetaApi
    public static GrpcStorageOptions getDefaultInstance() {
        return GrpcStorageOptions.newBuilder().build();
    }

    @BetaApi
    public static GrpcStorageDefaults defaults() {
        return GrpcStorageDefaults.INSTANCE;
    }

    @Override
    protected boolean shouldRefreshService(Storage cachedService) {
        if (cachedService instanceof GrpcStorageImpl) {
            GrpcStorageImpl service = (GrpcStorageImpl)cachedService;
            return service.isClosed();
        }
        return super.shouldRefreshService(cachedService);
    }

    private static final class NoopGrpcInterceptorProvider
    implements GrpcInterceptorProvider,
    Serializable {
        private static final NoopGrpcInterceptorProvider INSTANCE = new NoopGrpcInterceptorProvider();

        private NoopGrpcInterceptorProvider() {
        }

        @Override
        public List<ClientInterceptor> getInterceptors() {
            return ImmutableList.of();
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    private static final class StorageSettingsBuilder
    extends StorageSettings.Builder {
        private StorageSettingsBuilder(StorageSettings settings) {
            super(settings);
        }

        @Override
        protected StorageSettings.Builder setInternalHeaderProvider(HeaderProvider internalHeaderProvider) {
            return (StorageSettings.Builder)super.setInternalHeaderProvider(internalHeaderProvider);
        }
    }

    private static class ReadObjectResumptionStrategy
    implements StreamResumptionStrategy<ReadObjectRequest, ReadObjectResponse> {
        private long readOffset = 0L;

        private ReadObjectResumptionStrategy() {
        }

        @Override
        public @NonNull StreamResumptionStrategy<ReadObjectRequest, ReadObjectResponse> createNew() {
            return new ReadObjectResumptionStrategy();
        }

        @Override
        public @NonNull ReadObjectResponse processResponse(ReadObjectResponse response) {
            this.readOffset += (long)response.getChecksummedData().getContent().size();
            return response;
        }

        @Override
        public @Nullable ReadObjectRequest getResumeRequest(ReadObjectRequest originalRequest) {
            if (this.readOffset != 0L) {
                return originalRequest.toBuilder().setReadOffset(this.readOffset).build();
            }
            return originalRequest;
        }

        @Override
        public boolean canResume() {
            return true;
        }
    }

    @InternalApi
    @BetaApi
    @Deprecated
    public static class GrpcStorageRpcFactory
    implements StorageRpcFactory {
        @InternalApi
        @Deprecated
        @BetaApi
        public GrpcStorageRpcFactory() {
        }

        @Override
        public ServiceRpc create(StorageOptions options) {
            throw new IllegalStateException("No supported for grpc");
        }
    }

    @InternalApi
    @BetaApi
    public static class GrpcStorageFactory
    implements StorageFactory {
        @InternalApi
        @Deprecated
        @BetaApi
        public GrpcStorageFactory() {
        }

        @Override
        public Storage create(StorageOptions options) {
            if (options instanceof GrpcStorageOptions) {
                GrpcStorageOptions grpcStorageOptions = (GrpcStorageOptions)options;
                try {
                    Tuple t2 = grpcStorageOptions.resolveSettingsAndOpts();
                    StorageSettings storageSettings = (StorageSettings)t2.x();
                    UnifiedOpts.Opts defaultOpts = (UnifiedOpts.Opts)t2.y();
                    return new GrpcStorageImpl(grpcStorageOptions, StorageClient.create(storageSettings), defaultOpts);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to instantiate gRPC com.google.cloud.storage.Storage client.", e);
                }
            }
            throw new IllegalArgumentException("Only GrpcStorageOptions supported");
        }
    }

    @BetaApi
    public static final class GrpcStorageDefaults
    extends StorageOptions.StorageDefaults {
        static final GrpcStorageDefaults INSTANCE = new GrpcStorageDefaults();
        static final StorageFactory STORAGE_FACTORY = new GrpcStorageFactory();
        static final StorageRpcFactory STORAGE_RPC_FACTORY = new GrpcStorageRpcFactory();
        static final GrpcInterceptorProvider INTERCEPTOR_PROVIDER = NoopGrpcInterceptorProvider.access$500();

        private GrpcStorageDefaults() {
        }

        @BetaApi
        public StorageFactory getDefaultServiceFactory() {
            return STORAGE_FACTORY;
        }

        @BetaApi
        public StorageRpcFactory getDefaultRpcFactory() {
            return STORAGE_RPC_FACTORY;
        }

        @Override
        @BetaApi
        public GrpcTransportOptions getDefaultTransportOptions() {
            return GrpcTransportOptions.newBuilder().build();
        }

        @BetaApi
        public StorageRetryStrategy getStorageRetryStrategy() {
            return StorageRetryStrategy.getDefaultStorageRetryStrategy();
        }

        @BetaApi
        public Duration getTerminationAwaitDuration() {
            return Duration.ofMinutes(1L);
        }

        @BetaApi
        public boolean isAttemptDirectPath() {
            return false;
        }

        @BetaApi
        public GrpcInterceptorProvider grpcInterceptorProvider() {
            return INTERCEPTOR_PROVIDER;
        }
    }

    @BetaApi
    public static final class Builder
    extends StorageOptions.Builder {
        private StorageRetryStrategy storageRetryStrategy;
        private Duration terminationAwaitDuration;
        private boolean attemptDirectPath = GrpcStorageDefaults.INSTANCE.isAttemptDirectPath();
        private GrpcInterceptorProvider grpcInterceptorProvider = GrpcStorageDefaults.INSTANCE.grpcInterceptorProvider();

        Builder() {
        }

        Builder(StorageOptions options) {
            super(options);
        }

        @BetaApi
        public Builder setTerminationAwaitDuration(Duration terminationAwaitDuration) {
            this.terminationAwaitDuration = Objects.requireNonNull(terminationAwaitDuration, "terminationAwaitDuration must be non null");
            return this;
        }

        @BetaApi
        public Builder setAttemptDirectPath(boolean attemptDirectPath) {
            this.attemptDirectPath = attemptDirectPath;
            return this;
        }

        @Override
        @BetaApi
        public Builder setTransportOptions(TransportOptions transportOptions) {
            if (!(transportOptions instanceof GrpcTransportOptions)) {
                throw new IllegalArgumentException("Only gRPC transport is allowed.");
            }
            super.setTransportOptions(transportOptions);
            return this;
        }

        @Override
        @BetaApi
        public Builder setStorageRetryStrategy(StorageRetryStrategy storageRetryStrategy) {
            this.storageRetryStrategy = Objects.requireNonNull(storageRetryStrategy, "storageRetryStrategy must be non null");
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        @BetaApi
        public Builder setServiceFactory(ServiceFactory<Storage, StorageOptions> serviceFactory) {
            super.setServiceFactory(serviceFactory);
            return this;
        }

        @Override
        @BetaApi
        public Builder setClock(ApiClock clock) {
            super.setClock(clock);
            return this;
        }

        @Override
        @BetaApi
        public Builder setProjectId(String projectId) {
            super.setProjectId(projectId);
            return this;
        }

        @Override
        @BetaApi
        public Builder setHost(String host) {
            super.setHost(host);
            return this;
        }

        @Override
        @BetaApi
        public Builder setCredentials(Credentials credentials) {
            super.setCredentials(credentials);
            return this;
        }

        @Override
        @BetaApi
        public Builder setRetrySettings(RetrySettings retrySettings) {
            super.setRetrySettings(retrySettings);
            return this;
        }

        @Override
        @BetaApi
        public Builder setServiceRpcFactory(ServiceRpcFactory<StorageOptions> serviceRpcFactory) {
            throw new UnsupportedOperationException("GrpcStorageOptions does not support setting a custom instance of ServiceRpcFactory");
        }

        @Override
        @BetaApi
        public Builder setHeaderProvider(HeaderProvider headerProvider) {
            super.setHeaderProvider(headerProvider);
            return this;
        }

        @Override
        @BetaApi
        public Builder setClientLibToken(String clientLibToken) {
            super.setClientLibToken(clientLibToken);
            return this;
        }

        @Override
        @BetaApi
        public Builder setQuotaProjectId(String quotaProjectId) {
            super.setQuotaProjectId(quotaProjectId);
            return this;
        }

        @BetaApi
        public Builder setGrpcInterceptorProvider(@NonNull GrpcInterceptorProvider grpcInterceptorProvider) {
            Objects.requireNonNull(grpcInterceptorProvider, "grpcInterceptorProvider must be non null");
            this.grpcInterceptorProvider = grpcInterceptorProvider;
            return this;
        }

        @Override
        @BetaApi
        public GrpcStorageOptions build() {
            return new GrpcStorageOptions(this, GrpcStorageOptions.defaults());
        }
    }
}

