/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.firebase.auth.ErrorInfo;
import com.google.firebase.auth.internal.UploadAccountResponse;
import com.google.firebase.internal.NonNull;
import java.util.List;

public final class UserImportResult {
    private final int users;
    private final ImmutableList<ErrorInfo> errors;

    UserImportResult(int users, UploadAccountResponse response) {
        ImmutableList.Builder errorsBuilder = ImmutableList.builder();
        List<UploadAccountResponse.ErrorInfo> errors = response.getErrors();
        if (errors != null) {
            Preconditions.checkArgument(users >= errors.size());
            for (UploadAccountResponse.ErrorInfo error : errors) {
                errorsBuilder.add(new ErrorInfo(error.getIndex(), error.getMessage()));
            }
        }
        this.users = users;
        this.errors = errorsBuilder.build();
    }

    public int getSuccessCount() {
        return this.users - this.errors.size();
    }

    public int getFailureCount() {
        return this.errors.size();
    }

    @NonNull
    public List<ErrorInfo> getErrors() {
        return this.errors;
    }
}

