/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseInterceptor;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.StringUtils;
import com.google.auth.ServiceAccountSigner;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteStreams;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseException;
import com.google.firebase.ImplFirebaseTrampolines;
import com.google.firebase.auth.FirebaseAuthException;
import com.google.firebase.auth.internal.CryptoSigner;
import com.google.firebase.auth.internal.Utils;
import com.google.firebase.internal.AbstractPlatformErrorHandler;
import com.google.firebase.internal.ApiClientUtils;
import com.google.firebase.internal.ErrorHandlingHttpClient;
import com.google.firebase.internal.HttpRequestInfo;
import com.google.firebase.internal.NonNull;
import java.io.IOException;

public class CryptoSigners {
    private static final String METADATA_SERVICE_URL = "http://metadata.google.internal/computeMetadata/v1/instance/service-accounts/default/email";

    private CryptoSigners() {
    }

    public static CryptoSigner getCryptoSigner(FirebaseApp firebaseApp) throws IOException {
        if (Utils.isEmulatorMode()) {
            return new EmulatorCryptoSigner();
        }
        GoogleCredentials credentials = ImplFirebaseTrampolines.getCredentials(firebaseApp);
        if (credentials instanceof ServiceAccountCredentials) {
            return new ServiceAccountCryptoSigner((ServiceAccountCredentials)credentials);
        }
        HttpRequestFactory requestFactory = ApiClientUtils.newAuthorizedRequestFactory(firebaseApp);
        JsonFactory jsonFactory = firebaseApp.getOptions().getJsonFactory();
        String serviceAccountId = firebaseApp.getOptions().getServiceAccountId();
        if (!Strings.isNullOrEmpty(serviceAccountId)) {
            return new IAMCryptoSigner(requestFactory, jsonFactory, serviceAccountId);
        }
        if (credentials instanceof ServiceAccountSigner) {
            return new ServiceAccountCryptoSigner((ServiceAccountSigner)((Object)credentials));
        }
        serviceAccountId = CryptoSigners.discoverServiceAccountId(firebaseApp);
        return new IAMCryptoSigner(requestFactory, jsonFactory, serviceAccountId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String discoverServiceAccountId(FirebaseApp firebaseApp) throws IOException {
        HttpRequestFactory metadataRequestFactory = ApiClientUtils.newUnauthorizedRequestFactory(firebaseApp);
        HttpRequest request = metadataRequestFactory.buildGetRequest(new GenericUrl(METADATA_SERVICE_URL));
        request.getHeaders().set("Metadata-Flavor", "Google");
        HttpResponse response = request.execute();
        try {
            byte[] output = ByteStreams.toByteArray(response.getContent());
            String string = StringUtils.newStringUtf8(output).trim();
            return string;
        }
        finally {
            ApiClientUtils.disconnectQuietly(response);
        }
    }

    private static class IAMErrorHandler
    extends AbstractPlatformErrorHandler<FirebaseAuthException> {
        IAMErrorHandler(JsonFactory jsonFactory) {
            super(jsonFactory);
        }

        @Override
        protected FirebaseAuthException createException(FirebaseException base) {
            return new FirebaseAuthException(base);
        }
    }

    public static class EmulatorCryptoSigner
    implements CryptoSigner {
        private static final String ACCOUNT = "firebase-auth-emulator@example.com";

        @Override
        public byte[] sign(byte[] payload) {
            return "".getBytes();
        }

        @Override
        public String getAccount() {
            return ACCOUNT;
        }
    }

    static class IAMCryptoSigner
    implements CryptoSigner {
        private static final String IAM_SIGN_BLOB_URL = "https://iamcredentials.googleapis.com/v1/projects/-/serviceAccounts/%s:signBlob";
        private final String serviceAccount;
        private final ErrorHandlingHttpClient<FirebaseAuthException> httpClient;

        IAMCryptoSigner(@NonNull HttpRequestFactory requestFactory, @NonNull JsonFactory jsonFactory, @NonNull String serviceAccount) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(serviceAccount));
            this.serviceAccount = serviceAccount;
            this.httpClient = new ErrorHandlingHttpClient<FirebaseAuthException>(requestFactory, jsonFactory, new IAMErrorHandler(jsonFactory));
        }

        void setInterceptor(HttpResponseInterceptor interceptor) {
            this.httpClient.setInterceptor(interceptor);
        }

        @Override
        public byte[] sign(byte[] payload) throws FirebaseAuthException {
            String encodedPayload = BaseEncoding.base64().encode(payload);
            ImmutableMap<String, String> content = ImmutableMap.of("payload", encodedPayload);
            String encodedUrl = String.format(IAM_SIGN_BLOB_URL, this.serviceAccount);
            HttpRequestInfo requestInfo = HttpRequestInfo.buildJsonPostRequest(encodedUrl, content);
            GenericJson parsed = this.httpClient.sendAndParse(requestInfo, GenericJson.class);
            return BaseEncoding.base64().decode((String)parsed.get("signedBlob"));
        }

        @Override
        public String getAccount() {
            return this.serviceAccount;
        }
    }

    static class ServiceAccountCryptoSigner
    implements CryptoSigner {
        private final ServiceAccountSigner signer;

        ServiceAccountCryptoSigner(@NonNull ServiceAccountSigner signer) {
            this.signer = Preconditions.checkNotNull(signer);
        }

        @Override
        public byte[] sign(byte[] payload) {
            return this.signer.sign(payload);
        }

        @Override
        public String getAccount() {
            return this.signer.getAccount();
        }
    }
}

