/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.connection;

import com.google.common.annotations.VisibleForTesting;
import com.google.firebase.database.connection.ConnectionContext;
import com.google.firebase.database.connection.HostInfo;
import com.google.firebase.database.connection.WebsocketConnection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Connection
implements WebsocketConnection.Delegate {
    private static final String REQUEST_TYPE = "t";
    private static final String REQUEST_TYPE_DATA = "d";
    private static final String REQUEST_PAYLOAD = "d";
    private static final String SERVER_ENVELOPE_TYPE = "t";
    private static final String SERVER_DATA_MESSAGE = "d";
    private static final String SERVER_CONTROL_MESSAGE = "c";
    private static final String SERVER_ENVELOPE_DATA = "d";
    private static final String SERVER_CONTROL_MESSAGE_TYPE = "t";
    private static final String SERVER_CONTROL_MESSAGE_SHUTDOWN = "s";
    private static final String SERVER_CONTROL_MESSAGE_RESET = "r";
    private static final String SERVER_CONTROL_MESSAGE_HELLO = "h";
    private static final String SERVER_CONTROL_MESSAGE_DATA = "d";
    private static final String SERVER_HELLO_TIMESTAMP = "ts";
    private static final String SERVER_HELLO_HOST = "h";
    private static final String SERVER_HELLO_SESSION_ID = "s";
    private static final Logger logger = LoggerFactory.getLogger(Connection.class);
    private static long connectionIds = 0L;
    private final HostInfo hostInfo;
    private final Delegate delegate;
    private final String label;
    private WebsocketConnection conn;
    private State state;

    Connection(ConnectionContext context, HostInfo hostInfo, String cachedHost, Delegate delegate, String optLastSessionId) {
        this(hostInfo, delegate, new DefaultWebsocketConnectionFactory(context, hostInfo, cachedHost, optLastSessionId));
    }

    @VisibleForTesting
    Connection(HostInfo hostInfo, Delegate delegate, WebsocketConnectionFactory connFactory) {
        long connId = connectionIds++;
        this.hostInfo = hostInfo;
        this.delegate = delegate;
        this.label = "[conn_" + connId + "]";
        this.state = State.REALTIME_CONNECTING;
        this.conn = connFactory.newConnection(this);
    }

    public void open() {
        logger.debug("{} Opening a connection", (Object)this.label);
        this.conn.open();
    }

    public void close(DisconnectReason reason) {
        if (this.state != State.REALTIME_DISCONNECTED) {
            logger.debug("{} Closing realtime connection", (Object)this.label);
            this.state = State.REALTIME_DISCONNECTED;
            if (this.conn != null) {
                this.conn.close();
                this.conn = null;
            }
            this.delegate.onDisconnect(reason);
        }
    }

    public void close() {
        this.close(DisconnectReason.OTHER);
    }

    public void sendRequest(Map<String, Object> message, boolean isSensitive) {
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("t", "d");
        request.put("d", message);
        this.sendData(request, isSensitive);
    }

    @Override
    public void onMessage(Map<String, Object> message) {
        try {
            String messageType = (String)message.get("t");
            if (messageType != null) {
                if (messageType.equals("d")) {
                    Map data = (Map)message.get("d");
                    this.onDataMessage(data);
                } else if (messageType.equals(SERVER_CONTROL_MESSAGE)) {
                    Map data = (Map)message.get("d");
                    this.onControlMessage(data);
                } else {
                    logger.debug("{} Ignoring unknown server message type: {}", (Object)this.label, (Object)messageType);
                }
            } else {
                logger.debug("{} Failed to parse server message: missing message type: {}", (Object)this.label, (Object)message);
                this.close();
            }
        }
        catch (ClassCastException e) {
            logger.debug("{} Failed to parse server message", (Object)this.label, (Object)e);
            this.close();
        }
    }

    @Override
    public void onDisconnect(boolean wasEverConnected) {
        this.conn = null;
        if (!wasEverConnected && this.state == State.REALTIME_CONNECTING) {
            logger.debug("{} Realtime connection failed", (Object)this.label);
        } else {
            logger.debug("{} Realtime connection lost", (Object)this.label);
        }
        this.close();
    }

    private void onDataMessage(Map<String, Object> data) {
        logger.debug("{} Received data message: {}", (Object)this.label, (Object)data);
        this.delegate.onDataMessage(data);
    }

    private void onControlMessage(Map<String, Object> data) {
        logger.debug("{} Got control message: {}", (Object)this.label, (Object)data);
        try {
            String messageType = (String)data.get("t");
            if (messageType != null) {
                if (messageType.equals("s")) {
                    String reason = (String)data.get("d");
                    this.onConnectionShutdown(reason);
                } else if (messageType.equals(SERVER_CONTROL_MESSAGE_RESET)) {
                    String host = (String)data.get("d");
                    this.onReset(host);
                } else if (messageType.equals("h")) {
                    Map handshakeData = (Map)data.get("d");
                    this.onHandshake(handshakeData);
                } else {
                    logger.debug("{} Ignoring unknown control message: {}", (Object)this.label, (Object)messageType);
                }
            } else {
                logger.debug("{} Got invalid control message: {}", (Object)this.label, (Object)data);
                this.close();
            }
        }
        catch (ClassCastException e) {
            logger.debug("{} Failed to parse control message", (Object)this.label, (Object)e);
            this.close();
        }
    }

    private void onConnectionShutdown(String reason) {
        logger.debug("{} Connection shutdown command received. Shutting down...", (Object)this.label);
        this.delegate.onKill(reason);
        this.close();
    }

    private void onHandshake(Map<String, Object> handshake) {
        long timestamp = (Long)handshake.get(SERVER_HELLO_TIMESTAMP);
        String host = (String)handshake.get("h");
        this.delegate.onCacheHost(host);
        String sessionId = (String)handshake.get("s");
        if (this.state == State.REALTIME_CONNECTING) {
            this.conn.start();
            this.onConnectionReady(timestamp, sessionId);
        }
    }

    private void onConnectionReady(long timestamp, String sessionId) {
        logger.debug("{} Realtime connection established", (Object)this.label);
        this.state = State.REALTIME_CONNECTED;
        this.delegate.onReady(timestamp, sessionId);
    }

    private void onReset(String host) {
        logger.debug("{} Got a reset; killing connection to {}; Updating internalHost to {}", this.label, this.hostInfo.getHost(), host);
        this.delegate.onCacheHost(host);
        this.close(DisconnectReason.SERVER_RESET);
    }

    private void sendData(Map<String, Object> data, boolean isSensitive) {
        if (this.state != State.REALTIME_CONNECTED) {
            logger.debug("{} Tried to send on an unconnected connection", (Object)this.label);
        } else {
            if (isSensitive) {
                logger.debug("{} Sending data (contents hidden)", (Object)this.label);
            } else {
                logger.debug("{} Sending data: {}", (Object)this.label, (Object)data);
            }
            this.conn.send(data);
        }
    }

    public static interface Delegate {
        public void onCacheHost(String var1);

        public void onReady(long var1, String var3);

        public void onDataMessage(Map<String, Object> var1);

        public void onDisconnect(DisconnectReason var1);

        public void onKill(String var1);
    }

    private static class DefaultWebsocketConnectionFactory
    implements WebsocketConnectionFactory {
        final ConnectionContext context;
        final HostInfo hostInfo;
        final String cachedHost;
        final String optLastSessionId;

        DefaultWebsocketConnectionFactory(ConnectionContext context, HostInfo hostInfo, String cachedHost, String optLastSessionId) {
            this.context = context;
            this.hostInfo = hostInfo;
            this.cachedHost = cachedHost;
            this.optLastSessionId = optLastSessionId;
        }

        @Override
        public WebsocketConnection newConnection(WebsocketConnection.Delegate delegate) {
            return new WebsocketConnection(this.context, this.hostInfo, this.cachedHost, delegate, this.optLastSessionId);
        }
    }

    static interface WebsocketConnectionFactory {
        public WebsocketConnection newConnection(WebsocketConnection.Delegate var1);
    }

    private static enum State {
        REALTIME_CONNECTING,
        REALTIME_CONNECTED,
        REALTIME_DISCONNECTED;

    }

    public static enum DisconnectReason {
        SERVER_RESET,
        OTHER;

    }
}

