/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import com.google.api.client.util.Key;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.firebase.internal.NonNull;
import java.util.ArrayList;
import java.util.List;

public class ApsAlert {
    @Key(value="title")
    private final String title;
    @Key(value="subtitle")
    private final String subtitle;
    @Key(value="body")
    private final String body;
    @Key(value="loc-key")
    private final String locKey;
    @Key(value="loc-args")
    private final List<String> locArgs;
    @Key(value="title-loc-key")
    private final String titleLocKey;
    @Key(value="title-loc-args")
    private final List<String> titleLocArgs;
    @Key(value="subtitle-loc-key")
    private final String subtitleLocKey;
    @Key(value="subtitle-loc-args")
    private final List<String> subtitleLocArgs;
    @Key(value="action-loc-key")
    private final String actionLocKey;
    @Key(value="launch-image")
    private final String launchImage;

    private ApsAlert(Builder builder) {
        this.title = builder.title;
        this.subtitle = builder.subtitle;
        this.body = builder.body;
        this.actionLocKey = builder.actionLocKey;
        this.locKey = builder.locKey;
        if (!builder.locArgs.isEmpty()) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(builder.locKey), "locKey is required when specifying locArgs");
            this.locArgs = ImmutableList.copyOf(builder.locArgs);
        } else {
            this.locArgs = null;
        }
        this.titleLocKey = builder.titleLocKey;
        if (!builder.titleLocArgs.isEmpty()) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(builder.titleLocKey), "titleLocKey is required when specifying titleLocArgs");
            this.titleLocArgs = ImmutableList.copyOf(builder.titleLocArgs);
        } else {
            this.titleLocArgs = null;
        }
        this.subtitleLocKey = builder.subtitleLocKey;
        if (!builder.subtitleLocArgs.isEmpty()) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(builder.subtitleLocKey), "subtitleLocKey is required when specifying subtitleLocArgs");
            this.subtitleLocArgs = ImmutableList.copyOf(builder.subtitleLocArgs);
        } else {
            this.subtitleLocArgs = null;
        }
        this.launchImage = builder.launchImage;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String title;
        private String subtitle;
        private String body;
        private String locKey;
        private List<String> locArgs = new ArrayList<String>();
        private String titleLocKey;
        private List<String> titleLocArgs = new ArrayList<String>();
        private String subtitleLocKey;
        private List<String> subtitleLocArgs = new ArrayList<String>();
        private String actionLocKey;
        private String launchImage;

        private Builder() {
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setSubtitle(String subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public Builder setBody(String body) {
            this.body = body;
            return this;
        }

        public Builder setActionLocalizationKey(String actionLocKey) {
            this.actionLocKey = actionLocKey;
            return this;
        }

        public Builder setLocalizationKey(String locKey) {
            this.locKey = locKey;
            return this;
        }

        public Builder addLocalizationArg(@NonNull String arg) {
            this.locArgs.add(arg);
            return this;
        }

        public Builder addAllLocalizationArgs(@NonNull List<String> args) {
            this.locArgs.addAll(args);
            return this;
        }

        public Builder setTitleLocalizationKey(String titleLocKey) {
            this.titleLocKey = titleLocKey;
            return this;
        }

        public Builder addTitleLocalizationArg(@NonNull String arg) {
            this.titleLocArgs.add(arg);
            return this;
        }

        public Builder addAllTitleLocArgs(@NonNull List<String> args) {
            this.titleLocArgs.addAll(args);
            return this;
        }

        public Builder setSubtitleLocalizationKey(String subtitleLocKey) {
            this.subtitleLocKey = subtitleLocKey;
            return this;
        }

        public Builder addSubtitleLocalizationArg(@NonNull String arg) {
            this.subtitleLocArgs.add(arg);
            return this;
        }

        public Builder addAllSubtitleLocArgs(@NonNull List<String> args) {
            this.subtitleLocArgs.addAll(args);
            return this;
        }

        public Builder setLaunchImage(String launchImage) {
            this.launchImage = launchImage;
            return this;
        }

        public ApsAlert build() {
            return new ApsAlert(this);
        }
    }
}

