/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponseInterceptor;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseException;
import com.google.firebase.internal.AbstractHttpErrorHandler;
import com.google.firebase.internal.ApiClientUtils;
import com.google.firebase.internal.ErrorHandlingHttpClient;
import com.google.firebase.internal.HttpRequestInfo;
import com.google.firebase.internal.Nullable;
import com.google.firebase.messaging.FirebaseMessagingException;
import com.google.firebase.messaging.InstanceIdClient;
import com.google.firebase.messaging.TopicManagementResponse;
import java.io.IOException;
import java.util.List;

final class InstanceIdClientImpl
implements InstanceIdClient {
    private static final String IID_HOST = "https://iid.googleapis.com";
    private static final String IID_SUBSCRIBE_PATH = "iid/v1:batchAdd";
    private static final String IID_UNSUBSCRIBE_PATH = "iid/v1:batchRemove";
    private final ErrorHandlingHttpClient<FirebaseMessagingException> requestFactory;

    InstanceIdClientImpl(HttpRequestFactory requestFactory, JsonFactory jsonFactory) {
        this(requestFactory, jsonFactory, null);
    }

    InstanceIdClientImpl(HttpRequestFactory requestFactory, JsonFactory jsonFactory, @Nullable HttpResponseInterceptor responseInterceptor) {
        InstanceIdErrorHandler errorHandler = new InstanceIdErrorHandler(jsonFactory);
        this.requestFactory = new ErrorHandlingHttpClient<FirebaseMessagingException>(requestFactory, jsonFactory, errorHandler).setInterceptor(responseInterceptor);
    }

    static InstanceIdClientImpl fromApp(FirebaseApp app) {
        return new InstanceIdClientImpl(ApiClientUtils.newAuthorizedRequestFactory(app), app.getOptions().getJsonFactory());
    }

    @Override
    public TopicManagementResponse subscribeToTopic(String topic, List<String> registrationTokens) throws FirebaseMessagingException {
        return this.sendInstanceIdRequest(topic, registrationTokens, IID_SUBSCRIBE_PATH);
    }

    @Override
    public TopicManagementResponse unsubscribeFromTopic(String topic, List<String> registrationTokens) throws FirebaseMessagingException {
        return this.sendInstanceIdRequest(topic, registrationTokens, IID_UNSUBSCRIBE_PATH);
    }

    private TopicManagementResponse sendInstanceIdRequest(String topic, List<String> registrationTokens, String path) throws FirebaseMessagingException {
        String url = String.format("%s/%s", IID_HOST, path);
        ImmutableMap<String, List<String>> payload = ImmutableMap.of("to", this.getPrefixedTopic(topic), "registration_tokens", registrationTokens);
        HttpRequestInfo request = HttpRequestInfo.buildJsonPostRequest(url, payload).addHeader("access_token_auth", "true");
        InstanceIdServiceResponse response = new InstanceIdServiceResponse();
        this.requestFactory.sendAndParse(request, response);
        return new TopicManagementResponse(response.results);
    }

    private String getPrefixedTopic(String topic) {
        if (topic.startsWith("/topics/")) {
            return topic;
        }
        return "/topics/" + topic;
    }

    private static class InstanceIdErrorHandler
    extends AbstractHttpErrorHandler<FirebaseMessagingException> {
        private final JsonFactory jsonFactory;

        InstanceIdErrorHandler(JsonFactory jsonFactory) {
            this.jsonFactory = jsonFactory;
        }

        @Override
        protected FirebaseMessagingException createException(FirebaseException base) {
            String message = this.getCustomMessage(base);
            return FirebaseMessagingException.withCustomMessage(base, message);
        }

        private String getCustomMessage(FirebaseException base) {
            String response = this.getResponse(base);
            InstanceIdServiceErrorResponse parsed = this.safeParse(response);
            if (!Strings.isNullOrEmpty(parsed.error)) {
                return "Error while calling the IID service: " + parsed.error;
            }
            return base.getMessage();
        }

        private String getResponse(FirebaseException base) {
            if (base.getHttpResponse() == null) {
                return null;
            }
            return base.getHttpResponse().getContent();
        }

        private InstanceIdServiceErrorResponse safeParse(String response) {
            InstanceIdServiceErrorResponse parsed = new InstanceIdServiceErrorResponse();
            if (!Strings.isNullOrEmpty(response)) {
                try {
                    this.jsonFactory.createJsonParser(response).parse(parsed);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return parsed;
        }
    }

    private static class InstanceIdServiceErrorResponse {
        @Key(value="error")
        private String error;

        private InstanceIdServiceErrorResponse() {
        }
    }

    private static class InstanceIdServiceResponse {
        @Key(value="results")
        private List<GenericJson> results;

        private InstanceIdServiceResponse() {
        }
    }
}

