/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.Fun;

import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import serveressentials.serveressentials.util.FunMessages;

public class ThunderCommand
implements CommandExecutor,
TabCompleter {
    private final FunMessages messages;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();

    public ThunderCommand(FunMessages messages) {
        this.messages = messages;
        messages.addDefault("Thunder.PlayerOnly", "<red>Only players can use this command!");
        messages.addDefault("Thunder.Struck", "<yellow>Thunder effect summoned at {target}!");
        messages.addDefault("Thunder.SelfName", "yourself");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player found;
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.messages.get("Thunder.PlayerOnly"));
            return true;
        }
        Player player = (Player)sender;
        Player target = player;
        if (args.length > 0 && (found = Bukkit.getPlayerExact((String)args[0])) != null) {
            target = found;
        }
        Location loc = target.getLocation();
        target.getWorld().strikeLightningEffect(loc);
        String targetName = target.equals((Object)player) ? this.messages.getConfig().getString("Thunder.SelfName", "yourself") : target.getName();
        String msgRaw = this.messages.getConfig().getString("Thunder.Struck", "<yellow>Thunder effect summoned at {target}!");
        msgRaw = msgRaw.replace("{target}", targetName);
        player.sendMessage(this.miniMessage.deserialize(msgRaw));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            ArrayList<String> suggestions = new ArrayList<String>();
            Bukkit.getOnlinePlayers().forEach(p -> suggestions.add(p.getName()));
            return suggestions;
        }
        return null;
    }
}

