/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.Managers;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class ConsoleCommandManager {
    private static JavaPlugin plugin;
    private static FileConfiguration config;
    private static File configFile;

    public ConsoleCommandManager(JavaPlugin pl) {
        plugin = pl;
        ConsoleCommandManager.loadConfig();
    }

    private static void loadConfig() {
        File configFolder;
        File pluginFolder = plugin.getDataFolder();
        if (!pluginFolder.exists()) {
            pluginFolder.mkdirs();
        }
        if (!(configFolder = new File(pluginFolder, "config/ConsoleCommands")).exists()) {
            configFolder.mkdirs();
        }
        if (!(configFile = new File(configFolder, "consolecommands.yml")).exists()) {
            try {
                configFile.createNewFile();
                YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((File)configFile);
                defaultConfig.set("example.console", List.of("say %player% executed a command!"));
                defaultConfig.set("example.player", List.of("give %player% minecraft:stone 1"));
                defaultConfig.save(configFile);
            }
            catch (IOException e) {
                Bukkit.getLogger().severe("[ServerEssentials] Could not create consolecommands.yml!");
                e.printStackTrace();
            }
        }
        config = YamlConfiguration.loadConfiguration((File)configFile);
    }

    public static void reload() {
        if (plugin == null) {
            Bukkit.getLogger().severe("[ServerEssentials] ConsoleCommandManager plugin reference is null!");
            return;
        }
        if (configFile == null || !configFile.exists()) {
            ConsoleCommandManager.loadConfig();
        }
        config = YamlConfiguration.loadConfiguration((File)configFile);
        Bukkit.getLogger().info("[ServerEssentials] ConsoleCommandManager reloaded.");
    }

    public void runCommands(String path, Player player) {
        if (config.contains(path + ".console")) {
            List consoleCmds = config.getStringList(path + ".console");
            for (String cmd : consoleCmds) {
                if (cmd == null || cmd.trim().isEmpty()) continue;
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)cmd.replace("%player%", player.getName()));
            }
        }
        if (config.contains(path + ".player")) {
            List playerCmds = config.getStringList(path + ".player");
            for (String cmd : playerCmds) {
                if (cmd == null || cmd.trim().isEmpty()) continue;
                player.performCommand(cmd.replace("%player%", player.getName()));
            }
        }
    }

    public FileConfiguration getConfig() {
        return config;
    }
}

