/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.Player;

import net.kyori.adventure.text.Component;
import org.bukkit.Statistic;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import serveressentials.serveressentials.util.PlayerMessages;

public class PlaytimeCommand
implements CommandExecutor {
    private final PlayerMessages messages;

    public PlaytimeCommand(PlayerMessages messages) {
        this.messages = messages;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.messages.get("Playtime.not-a-player", new String[0]));
            return true;
        }
        Player player = (Player)sender;
        if (args.length > 0) {
            sender.sendMessage(this.messages.get("Playtime.usage", new String[0]));
            return true;
        }
        long ticks = player.getStatistic(Statistic.PLAY_ONE_MINUTE);
        long minutes = ticks / 1200L;
        long hours = minutes / 60L;
        long remainingMinutes = minutes % 60L;
        Component playtimeMsg = this.messages.get("Playtime.playtime", "{player}", player.getName(), "{hours}", String.valueOf(hours), "{minutes}", String.valueOf(remainingMinutes));
        player.sendMessage(playtimeMsg);
        return true;
    }
}

