/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.Player;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import serveressentials.serveressentials.ServerEssentials;
import serveressentials.serveressentials.util.PlayerMessages;

public class ReportCommand
implements CommandExecutor,
TabExecutor {
    private final ServerEssentials plugin;
    private final PlayerMessages messages;
    private File file;
    private FileConfiguration config;

    public ReportCommand(ServerEssentials plugin, PlayerMessages messages) {
        this.plugin = plugin;
        this.messages = messages;
        this.loadReports();
    }

    private void loadReports() {
        this.file = new File(String.valueOf(this.plugin.getDataFolder()) + File.separator + "storage", "reports.yml");
        if (!this.file.getParentFile().exists()) {
            this.file.getParentFile().mkdirs();
        }
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    private void saveReports() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("report")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage("Only players can use this command.");
                return true;
            }
            Player player = (Player)sender;
            if (args.length < 2) {
                player.sendMessage(this.messages.get("report.usage", "{usage}", "/report <player> <reason>"));
                return true;
            }
            OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[0]);
            if (target == null || !target.hasPlayedBefore() && !target.isOnline()) {
                player.sendMessage(this.messages.get("report.invalid-player", "{player}", args[0]));
                return true;
            }
            String reason = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
            String id = UUID.randomUUID().toString().substring(0, 8);
            this.config.set("reports." + id + ".reporter", (Object)player.getUniqueId().toString());
            this.config.set("reports." + id + ".target", (Object)target.getUniqueId().toString());
            this.config.set("reports." + id + ".reason", (Object)reason);
            this.config.set("reports." + id + ".timestamp", (Object)System.currentTimeMillis());
            this.saveReports();
            player.sendMessage(this.messages.get("report.submitted", "{player}", target.getName(), "{reason}", reason));
            Component notifyMsg = this.messages.get("report.notify", "{id}", id, "{reporter}", player.getName(), "{target}", target.getName(), "{reason}", reason);
            boolean notified = false;
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (!p.isOp() && !p.hasPermission("serveressentials.report.admin")) continue;
                p.sendMessage(notifyMsg);
                notified = true;
            }
            if (!notified) {
                this.config.set("pending." + id, (Object)true);
                this.saveReports();
            }
            return true;
        }
        if (command.getName().equalsIgnoreCase("reportclear")) {
            if (!sender.isOp() && !sender.hasPermission("serveressentials.report.admin")) {
                sender.sendMessage(this.messages.get("report.no-permission", new String[0]));
                return true;
            }
            if (args.length < 1) {
                sender.sendMessage(this.messages.get("reportclear.usage", "{usage}", "/reportclear <id>"));
                return true;
            }
            String id = args[0];
            if (this.config.contains("reports." + id)) {
                this.config.set("reports." + id, null);
                this.saveReports();
                sender.sendMessage(this.messages.get("reportclear.cleared", "{id}", id));
            } else {
                sender.sendMessage(this.messages.get("reportclear.invalid", "{id}", id));
            }
            return true;
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (command.getName().equalsIgnoreCase("report") && args.length == 1) {
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
        }
        if (command.getName().equalsIgnoreCase("reportclear") && args.length == 1 && this.config.contains("reports")) {
            return new ArrayList<String>(this.config.getConfigurationSection("reports").getKeys(false));
        }
        return Collections.emptyList();
    }

    public void handleJoin(Player player) {
        if ((player.isOp() || player.hasPermission("serveressentials.report.admin")) && this.config.contains("pending")) {
            for (String id : this.config.getConfigurationSection("pending").getKeys(false)) {
                String targetUUID = this.config.getString("reports." + id + ".target");
                String reporterUUID = this.config.getString("reports." + id + ".reporter");
                String reason = this.config.getString("reports." + id + ".reason");
                OfflinePlayer target = Bukkit.getOfflinePlayer((UUID)UUID.fromString(targetUUID));
                OfflinePlayer reporter = Bukkit.getOfflinePlayer((UUID)UUID.fromString(reporterUUID));
                player.sendMessage(this.messages.get("report.notify", "{id}", id, "{reporter}", reporter.getName(), "{target}", target.getName(), "{reason}", reason));
            }
            this.config.set("pending", null);
            this.saveReports();
        }
    }
}

