/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.staff;

import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import serveressentials.serveressentials.ServerEssentials;
import serveressentials.serveressentials.util.MessagesManager;

public class EnderSeeCommand
implements CommandExecutor,
TabCompleter {
    private final ServerEssentials plugin;
    private final MessagesManager messages;

    public EnderSeeCommand(ServerEssentials plugin, MessagesManager messages) {
        this.plugin = plugin;
        this.messages = messages;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage((Component)Component.text("Only players can use this command."));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("serveressentials.endersee")) {
            player.sendMessage(this.messages.get("staff.yml", "endersee.no-permission", new String[0]));
            return true;
        }
        if (args.length != 1) {
            player.sendMessage(this.messages.get("staff.yml", "endersee.usage", "{usage}", "/endersee <player>"));
            return true;
        }
        Player target = Bukkit.getPlayerExact((String)args[0]);
        if (target == null) {
            player.sendMessage(this.messages.get("staff.yml", "endersee.invalid-player", "{player}", args[0]));
            return true;
        }
        Inventory enderChestCopy = Bukkit.createInventory(null, (int)27, (Component)Component.text("EnderChest of " + target.getName()));
        ItemStack[] contents = target.getEnderChest().getContents();
        enderChestCopy.setContents(contents);
        player.openInventory(enderChestCopy);
        player.sendMessage(this.messages.get("staff.yml", "endersee.opened", "{player}", target.getName()));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> suggestions = new ArrayList<String>();
        if (args.length == 1) {
            for (Player p : Bukkit.getOnlinePlayers()) {
                suggestions.add(p.getName());
            }
        }
        return suggestions;
    }
}

