/*
 * Decompiled with CFR 0.152.
 */
package serveressentials.serveressentials.staff;

import java.util.UUID;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import serveressentials.serveressentials.ServerEssentials;
import serveressentials.serveressentials.staff.BanManager;
import serveressentials.serveressentials.util.MessagesManager;

public class UnbanCommand
implements CommandExecutor {
    private final BanManager banManager;
    private final MessagesManager messages;

    public UnbanCommand(ServerEssentials plugin, BanManager banManager) {
        this.banManager = banManager;
        this.messages = new MessagesManager(plugin);
        this.messages.addDefault("unban.no-permission", "<red>You don't have permission.");
        this.messages.addDefault("unban.usage", "<red>Usage: /unban <player>");
        this.messages.addDefault("unban.player-not-found", "<red>Could not find banned player with name '<yellow>%player%</yellow>'.");
        this.messages.addDefault("unban.not-banned", "<yellow>%player%</yellow> is not currently banned.");
        this.messages.addDefault("unban.success", "<green>%player%</green> has been unbanned.");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("ban.use")) {
            sender.sendMessage(this.messages.getMessageComponent("unban.no-permission", new String[0]));
            return true;
        }
        if (args.length != 1) {
            sender.sendMessage(this.messages.getMessageComponent("unban.usage", new String[0]));
            return true;
        }
        String playerName = args[0];
        UUID uuid = this.banManager.getUUIDFromName(playerName);
        if (uuid == null) {
            sender.sendMessage(this.messages.getMessageComponent("unban.player-not-found", "%player%", playerName));
            return true;
        }
        if (!this.banManager.isBanned(uuid)) {
            sender.sendMessage(this.messages.getMessageComponent("unban.not-banned", "%player%", playerName));
            return true;
        }
        this.banManager.unbanPlayer(uuid);
        sender.sendMessage(this.messages.getMessageComponent("unban.success", "%player%", playerName));
        return true;
    }
}

