/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class CommandExecutor {
    private final Plugin plugin;
    private final File flagFile;
    private final List<String> commands;

    public CommandExecutor(Plugin plugin) {
        this.plugin = plugin;
        this.flagFile = new File(plugin.getDataFolder(), ".installed");
        this.commands = List.of("papi ecloud download Vault");
    }

    public void runIfFirstInstall() {
        if (!this.flagFile.exists()) {
            this.plugin.getLogger().info("First install detected \u2013 running commands...");
            Bukkit.getScheduler().runTaskLater(this.plugin, () -> {
                for (String cmd : this.commands) {
                    if (cmd == null || cmd.isBlank()) continue;
                    String parsed = cmd.replace("@a", "@a").replace("@p", "@a");
                    boolean ok = Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)parsed);
                    if (ok) continue;
                    this.plugin.getLogger().warning("First-install command failed: " + parsed);
                }
                this.markAsInstalled();
            }, 20L);
        }
    }

    private void markAsInstalled() {
        try {
            this.flagFile.getParentFile().mkdirs();
            this.flagFile.createNewFile();
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not create first-install flag file \u2013 commands may re-run on restart!");
            e.printStackTrace();
        }
    }
}

