/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.Rtp;

import java.util.List;
import net.kyori.adventure.text.Component;
import net.lunark.io.Rtp.RtpConfig;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class RtpCommand
implements CommandExecutor {
    private final Plugin plugin;
    private final PlayerLanguageManager langManager;
    private final RtpConfig rtpConfig;

    public RtpCommand(Plugin plugin, PlayerLanguageManager langManager, RtpConfig rtpConfig) {
        this.plugin = plugin;
        this.langManager = langManager;
        this.rtpConfig = rtpConfig;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.langManager.getMessageFor(null, "commands.only_player", "Only players can use this command!", new LanguageManager.ComponentPlaceholder[0]).toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("serveressentials.command.rtp")) {
            player.sendMessage(this.langManager.getMessageFor(player, "commands.no_permission", "You don't have permission!", LanguageManager.ComponentPlaceholder.of("{permission}", "rtp.use")));
            return true;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("reload")) {
            if (!player.hasPermission("serveressentials.command.rtp.reload")) {
                player.sendMessage(this.langManager.getMessageFor(player, "commands.no_permission", "You don't have permission!", LanguageManager.ComponentPlaceholder.of("{permission}", "rtp.reload")));
                return true;
            }
            this.rtpConfig.reload();
            player.sendMessage(this.langManager.getMessageFor(player, "rtp.reloaded", "RTP configuration reloaded!", new LanguageManager.ComponentPlaceholder[0]));
            return true;
        }
        this.openRtpGui(player);
        return true;
    }

    private void openRtpGui(Player player) {
        Component title = this.langManager.getMessageFor(player, "rtp.gui.title", "<green>RTP Menu", new LanguageManager.ComponentPlaceholder[0]);
        Inventory gui = Bukkit.createInventory(null, (int)9, (Component)title);
        gui.setItem(2, this.createGuiItem(Material.GRASS_BLOCK, this.langManager.getMessageFor(player, "rtp.gui.overworld.name", "Overworld", new LanguageManager.ComponentPlaceholder[0]), this.langManager.getMessageList(player, "rtp.gui.overworld.lore")));
        gui.setItem(4, this.createGuiItem(Material.NETHERRACK, this.langManager.getMessageFor(player, "rtp.gui.nether.name", "Nether", new LanguageManager.ComponentPlaceholder[0]), this.langManager.getMessageList(player, "rtp.gui.nether.lore")));
        gui.setItem(6, this.createGuiItem(Material.END_STONE, this.langManager.getMessageFor(player, "rtp.gui.end.name", "The End", new LanguageManager.ComponentPlaceholder[0]), this.langManager.getMessageList(player, "rtp.gui.end.lore")));
        player.openInventory(gui);
    }

    private ItemStack createGuiItem(Material material, Component name, List<Component> lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(name);
        meta.lore(lore);
        item.setItemMeta(meta);
        return item;
    }
}

