/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.back;

import net.lunark.io.back.BackManager;
import net.lunark.io.commands.config.BackConfig;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class BackListener
implements Listener {
    private final BackManager backManager;
    private final BackConfig config;

    public BackListener(BackManager backManager, BackConfig config) {
        this.backManager = backManager;
        this.config = config;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.backManager.hasBack(player.getUniqueId()).thenAccept(has -> {
            if (has.booleanValue()) {
                Bukkit.getLogger().info("Player " + player.getName() + " has a saved back location");
            }
        });
    }

    @EventHandler
    public void onTeleport(PlayerTeleportEvent event) {
        if (!this.config.saveOnTeleport()) {
            return;
        }
        Player player = event.getPlayer();
        if (event.getFrom() != null && event.getFrom().getWorld() != null) {
            this.backManager.setLastLocation(player.getUniqueId(), event.getFrom()).thenRun(() -> Bukkit.getLogger().fine("Saved back location for " + player.getName()));
        }
    }

    @EventHandler
    public void onDeath(PlayerDeathEvent event) {
        if (!this.config.saveOnDeath()) {
            return;
        }
        Player player = event.getEntity();
        this.backManager.setLastLocation(player.getUniqueId(), player.getLocation());
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        if (!this.config.saveOnQuit()) {
            return;
        }
        Player player = event.getPlayer();
        this.backManager.setLastLocation(player.getUniqueId(), player.getLocation());
    }

    @EventHandler
    public void onRespawn(PlayerRespawnEvent event) {
        if (!this.config.saveOnRespawn()) {
            return;
        }
        Player player = event.getPlayer();
        Location deathLocation = player.getLastDeathLocation();
        if (deathLocation != null) {
            this.backManager.setLastLocation(player.getUniqueId(), deathLocation);
        }
    }
}

