/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.ban;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.lunark.io.database.DatabaseManager;
import org.bukkit.plugin.Plugin;

public class BanStorage {
    private final DatabaseManager dbManager;
    private final String poolKey = "bans";
    private final Plugin plugin;

    public BanStorage(Plugin plugin, DatabaseManager dbManager) {
        this.plugin = plugin;
        this.dbManager = dbManager;
        this.initTable();
    }

    private void initTable() {
        String sql = "CREATE TABLE IF NOT EXISTS bans (\n    uuid TEXT PRIMARY KEY,\n    name TEXT NOT NULL,\n    reason TEXT NOT NULL,\n    banned_by TEXT NOT NULL,\n    banned_until BIGINT NOT NULL,\n    server TEXT NOT NULL,\n    discord TEXT NOT NULL\n)\n";
        this.dbManager.executeUpdate("bans", sql, new Object[0]);
    }

    public CompletableFuture<Void> banPlayer(UUID uuid, String name, String reason, String bannedBy, long until, String server, String discord) {
        String sql = "INSERT OR REPLACE INTO bans VALUES (?, ?, ?, ?, ?, ?, ?)";
        return this.dbManager.executeUpdate("bans", sql, uuid.toString(), name, reason, bannedBy, until, server, discord);
    }

    public CompletableFuture<Boolean> isBanned(UUID uuid) {
        String sql = "SELECT banned_until FROM bans WHERE uuid = ?";
        return this.dbManager.executeQuery("bans", sql, rs -> rs.next() ? Long.valueOf(rs.getLong("banned_until")) : null, uuid.toString()).thenApply(optUntil -> optUntil.map(until -> {
            if (until == -1L) {
                return true;
            }
            return System.currentTimeMillis() <= until;
        }).orElse(false));
    }

    public CompletableFuture<Void> unbanPlayer(UUID uuid) {
        String sql = "DELETE FROM bans WHERE uuid = ?";
        return this.dbManager.executeUpdate("bans", sql, uuid.toString());
    }

    public CompletableFuture<Optional<BanData>> getBanData(UUID uuid) {
        String sql = "SELECT * FROM bans WHERE uuid = ?";
        return this.dbManager.executeQuery("bans", sql, this::mapBanData, uuid.toString());
    }

    public boolean isBannedSync(UUID uuid) {
        try {
            return this.isBanned(uuid).get(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            this.plugin.getLogger().severe("Failed to check ban status for " + String.valueOf(uuid) + ": " + e.getMessage());
            return false;
        }
    }

    private BanData mapBanData(ResultSet rs) throws SQLException {
        if (!rs.next()) {
            return null;
        }
        return new BanData(UUID.fromString(rs.getString("uuid")), rs.getString("name"), rs.getString("reason"), rs.getString("banned_by"), rs.getLong("banned_until"), rs.getString("server"), rs.getString("discord"));
    }

    public CompletableFuture<Optional<UUID>> getUUIDFromName(String name) {
        String sql = "SELECT uuid FROM bans WHERE LOWER(name) = LOWER(?)";
        return this.dbManager.executeQuery("bans", sql, rs -> rs.next() ? UUID.fromString(rs.getString("uuid")) : null, name);
    }

    public CompletableFuture<Set<String>> getAllBannedUUIDs() {
        String sql = "SELECT uuid FROM bans";
        return this.dbManager.executeQuery("bans", sql, rs -> {
            HashSet<String> uuids = new HashSet<String>();
            while (rs.next()) {
                uuids.add(rs.getString("uuid"));
            }
            return uuids;
        }, new Object[0]).thenApply(opt -> opt.orElseGet(HashSet::new));
    }

    public CompletableFuture<Optional<String>> getNameFromUUID(String uuid) {
        String sql = "SELECT name FROM bans WHERE uuid = ?";
        return this.dbManager.executeQuery("bans", sql, rs -> rs.next() ? rs.getString("name") : null, uuid);
    }

    public CompletableFuture<Optional<String>> getReason(UUID uuid) {
        String sql = "SELECT reason FROM bans WHERE uuid = ?";
        return this.dbManager.executeQuery("bans", sql, rs -> rs.next() ? rs.getString("reason") : null, uuid.toString());
    }

    public CompletableFuture<Optional<Long>> getUntil(UUID uuid) {
        String sql = "SELECT banned_until FROM bans WHERE uuid = ?";
        return this.dbManager.executeQuery("bans", sql, rs -> rs.next() ? Long.valueOf(rs.getLong("banned_until")) : null, uuid.toString());
    }

    public Optional<BanData> getBanDataSync(UUID uuid) {
        try {
            return this.getBanData(uuid).get(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            this.plugin.getLogger().severe("Failed to retrieve ban data for " + String.valueOf(uuid) + ": " + e.getMessage());
            return Optional.empty();
        }
    }

    public record BanData(UUID uuid, String name, String reason, String bannedBy, long until, String server, String discord) {
    }
}

