/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.lunark.io.commands.CommandState;
import net.lunark.io.database.DatabaseManager;
import org.bukkit.plugin.Plugin;

public class CommandDataStorage {
    private final DatabaseManager dbManager;
    private final String poolKey = "command_data";
    private final Plugin plugin;

    public CommandDataStorage(Plugin plugin, DatabaseManager dbManager) {
        this.plugin = plugin;
        this.dbManager = dbManager;
        this.initTable();
    }

    private void initTable() {
        String sql = "CREATE TABLE IF NOT EXISTS command_states (player_uuid TEXT NOT NULL, command TEXT NOT NULL, key TEXT NOT NULL, value TEXT, timestamp BIGINT, PRIMARY KEY (player_uuid, command, key))";
        this.dbManager.executeUpdate("command_data", sql, new Object[0]).exceptionally(ex -> {
            this.plugin.getLogger().severe("Failed to create command_states table: " + ex.getMessage());
            return null;
        });
    }

    public CompletableFuture<Void> setState(UUID playerId, String command, String key, String value) {
        String sql = "INSERT OR REPLACE INTO command_states (player_uuid, command, key, value, timestamp) VALUES (?, ?, ?, ?, ?)";
        return this.dbManager.executeUpdate("command_data", sql, playerId.toString(), command, key, value, System.currentTimeMillis());
    }

    public CompletableFuture<Optional<String>> getState(UUID playerId, String command, String key) {
        String sql = "SELECT value FROM command_states WHERE player_uuid = ? AND command = ? AND key = ?";
        return this.dbManager.executeQuery("command_data", sql, rs -> rs.next() ? rs.getString("value") : null, playerId.toString(), command, key);
    }

    public CompletableFuture<List<CommandState>> getAllStatesForCommand(UUID playerId, String command) {
        String sql = "SELECT key, value FROM command_states WHERE player_uuid = ? AND command = ?";
        return this.dbManager.executeQuery("command_data", sql, rs -> {
            ArrayList<CommandState> states = new ArrayList<CommandState>();
            while (rs.next()) {
                states.add(new CommandState(playerId, command, rs.getString("key"), rs.getString("value")));
            }
            return states;
        }, playerId.toString(), command).thenApply(opt -> opt.orElse(List.of()));
    }

    public CompletableFuture<Void> deleteState(UUID playerId, String command, String key) {
        String sql = "DELETE FROM command_states WHERE player_uuid = ? AND command = ? AND key = ?";
        return this.dbManager.executeUpdate("command_data", sql, playerId.toString(), command, key);
    }

    public CompletableFuture<Void> deleteAllForCommand(UUID playerId, String command) {
        String sql = "DELETE FROM command_states WHERE player_uuid = ? AND command = ?";
        return this.dbManager.executeUpdate("command_data", sql, playerId.toString(), command);
    }

    public CompletableFuture<Void> cleanupOldStates(long olderThanMillis) {
        String sql = "DELETE FROM command_states WHERE timestamp < ?";
        return this.dbManager.executeUpdate("command_data", sql, System.currentTimeMillis() - olderThanMillis);
    }
}

