/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands;

import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.lunark.io.commands.CommandDataStorage;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.entity.Player;

public abstract class CommandModule {
    protected final CommandDataStorage storage;
    protected final PlayerLanguageManager langManager;

    public CommandModule(CommandDataStorage storage, PlayerLanguageManager langManager) {
        this.storage = storage;
        this.langManager = langManager;
    }

    protected abstract String getCommandName();

    protected CompletableFuture<Boolean> getBooleanState(Player player, String key, boolean defaultValue) {
        return this.getBooleanState(player.getUniqueId(), key, defaultValue);
    }

    protected CompletableFuture<Boolean> getBooleanState(UUID playerId, String key, boolean defaultValue) {
        return this.storage.getState(playerId, this.getCommandName(), key).thenApply(opt -> opt.map(Boolean::parseBoolean).orElse(defaultValue));
    }

    protected CompletableFuture<Void> setBooleanState(Player player, String key, boolean value) {
        return this.setBooleanState(player.getUniqueId(), key, value);
    }

    protected CompletableFuture<Void> setBooleanState(UUID playerId, String key, boolean value) {
        return this.storage.setState(playerId, this.getCommandName(), key, String.valueOf(value));
    }

    protected CompletableFuture<Integer> getIntState(Player player, String key, int defaultValue) {
        return this.storage.getState(player.getUniqueId(), this.getCommandName(), key).thenApply(opt -> opt.map(Integer::parseInt).orElse(defaultValue));
    }

    protected CompletableFuture<Void> setIntState(Player player, String key, int value) {
        return this.storage.setState(player.getUniqueId(), this.getCommandName(), key, String.valueOf(value));
    }

    protected CompletableFuture<Optional<String>> getStringState(Player player, String key) {
        return this.storage.getState(player.getUniqueId(), this.getCommandName(), key);
    }

    protected CompletableFuture<Void> setStringState(Player player, String key, String value) {
        return this.storage.setState(player.getUniqueId(), this.getCommandName(), key, value);
    }

    protected CompletableFuture<Void> clearAllStates(Player player) {
        return this.storage.deleteAllForCommand(player.getUniqueId(), this.getCommandName());
    }
}

