/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.config;

import org.bukkit.plugin.Plugin;

public final class RulesConfig {
    private final String title;
    private final String acceptButtonText;
    private final String declineButtonText;
    private final boolean mustAccept;
    private final String kickMessage;
    private final String permission;
    private final String reloadPermission;
    private final String guiFillerMaterial;
    private final boolean forceAcceptance;
    private final int acceptButtonSlot;
    private final int declineButtonSlot;

    public RulesConfig(Plugin plugin) {
        this.title = plugin.getConfig().getString("rules.title", "<green>Server Rules");
        this.acceptButtonText = plugin.getConfig().getString("rules.accept-button-text", "<green><bold>\u2713 ACCEPT");
        this.declineButtonSlot = plugin.getConfig().getInt("rules.buttons.decline.slot", 53);
        this.declineButtonText = plugin.getConfig().getString("rules.decline-button-text", "<red><bold>\u2717 DECLINE");
        this.mustAccept = plugin.getConfig().getBoolean("rules.must-accept", true);
        this.forceAcceptance = plugin.getConfig().getBoolean("rules.force-acceptance", true);
        this.kickMessage = plugin.getConfig().getString("rules.kick-message", "<red>You must accept the rules to join this server!");
        this.guiFillerMaterial = plugin.getConfig().getString("rules.gui.filler-material", "GRAY_STAINED_GLASS_PANE");
        this.acceptButtonSlot = plugin.getConfig().getInt("rules.buttons.accept.slot", 45);
        this.permission = "serveressentials.command.rules";
        this.reloadPermission = "serveressentials.command.rules.reload";
    }

    public String title() {
        return this.title;
    }

    public String acceptButtonText() {
        return this.acceptButtonText;
    }

    public String declineButtonText() {
        return this.declineButtonText;
    }

    public boolean mustAccept() {
        return this.mustAccept;
    }

    public boolean forceAcceptance() {
        return this.forceAcceptance;
    }

    public String kickMessage() {
        return this.kickMessage;
    }

    public String permission() {
        return this.permission;
    }

    public String reloadPermission() {
        return this.reloadPermission;
    }

    public String guiFillerMaterial() {
        return this.guiFillerMaterial;
    }

    public int acceptButtonSlot() {
        return this.acceptButtonSlot;
    }

    public int declineButtonSlot() {
        return this.declineButtonSlot;
    }
}

