/*
 * Decompiled with CFR 0.152.
 */
package net.lunark.io.commands.impl;

import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.lunark.io.commands.CommandDataStorage;
import net.lunark.io.commands.config.BeezookaConfig;
import net.lunark.io.language.LanguageManager;
import net.lunark.io.language.PlayerLanguageManager;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Bee;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BeezookaCommand
implements CommandExecutor,
TabCompleter {
    private static final String PERMISSION = "serveressentials.command.beezooka";
    private final PlayerLanguageManager langManager;
    private final BeezookaConfig config;
    private final CommandDataStorage dataStorage;
    private final Plugin plugin;

    public BeezookaCommand(PlayerLanguageManager langManager, BeezookaConfig config, CommandDataStorage dataStorage, Plugin plugin) {
        this.langManager = langManager;
        this.config = config;
        this.dataStorage = dataStorage;
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!(sender instanceof Player)) {
            Component message = this.langManager.getMessageFor(null, "commands.beezooka.only-player", "<red>Only players can use this command!", new LanguageManager.ComponentPlaceholder[0]);
            sender.sendMessage(message.toString());
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission(PERMISSION)) {
            Component message = this.langManager.getMessageFor(player, "commands.beezooka.no-permission", "<red>You need permission <yellow>{permission}</yellow>!", LanguageManager.ComponentPlaceholder.of("{permission}", PERMISSION));
            player.sendMessage(message);
            return true;
        }
        if (args.length > 1) {
            Component message = this.langManager.getMessageFor(player, "commands.beezooka.usage", "<red>Usage: <white>/beezooka [velocity]", new LanguageManager.ComponentPlaceholder[0]);
            player.sendMessage(message);
            return true;
        }
        double velocity = this.config.getVelocity();
        if (args.length == 1) {
            try {
                velocity = Double.parseDouble(args[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        double finalVelocity = velocity;
        Bukkit.getScheduler().runTask(this.plugin, () -> {
            Bee bee = (Bee)player.getWorld().spawnEntity(player.getEyeLocation().add(player.getLocation().getDirection()), EntityType.BEE);
            Vector direction = player.getLocation().getDirection().multiply(finalVelocity);
            bee.setVelocity(direction);
            bee.setAnger(0);
            Component nameComponent = this.langManager.getMessageFor(player, "commands.beezooka.name", "<yellow>Beezooka Bee!", new LanguageManager.ComponentPlaceholder[0]);
            bee.customName(nameComponent);
            bee.setCustomNameVisible(true);
        });
        Component message = this.langManager.getMessageFor(player, "commands.beezooka.fired", "<green>Beezooka fired with velocity {velocity}!", LanguageManager.ComponentPlaceholder.of("{velocity}", String.valueOf(velocity)));
        player.sendMessage(message);
        this.trackUsage(player.getUniqueId(), "fired", 1);
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length == 1) {
            return List.of("1", "2", "3", "4", "5");
        }
        return List.of();
    }

    private void trackUsage(UUID playerId, String type, int value) {
        this.dataStorage.getState(playerId, "beezooka", "usage_count").thenAccept(opt -> {
            int count = opt.map(Integer::parseInt).orElse(0);
            this.dataStorage.setState(playerId, "beezooka", "usage_count", String.valueOf(count + 1));
            this.dataStorage.setState(playerId, "beezooka", "last_type", type);
            this.dataStorage.setState(playerId, "beezooka", "last_used", String.valueOf(System.currentTimeMillis()));
        });
    }
}

